/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.Property;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ObjectParam
extends Parameter {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.xml.ObjectParam");
    private String type;
    private String package_;
    private Object object_;
    private ArrayList properties_ = new ArrayList();

    public String getType() {
        return this.type;
    }

    public void setType(String s) {
        this.type = s;
        int idx = this.type.lastIndexOf(".");
        if (idx > 0) {
            this.package_ = this.type.substring(0, idx);
        }
    }

    public Object getObject() {
        if (this.object_ == null) {
            this.populateBean();
        }
        return this.object_;
    }

    public void addProperty(String name, String value) {
        this.properties_.add(new Property(name, value));
    }

    private void populateBean() {
        Property prop = null;
        try {
            Class clazz = Tools.forName((String)this.type, (Object)this);
            this.object_ = clazz.newInstance();
            for (int i = 0; i < this.properties_.size(); ++i) {
                prop = (Property)this.properties_.get(i);
                if (prop.name.endsWith("]")) {
                    this.populateBeanInArray(this.object_, prop.name, prop.value);
                    continue;
                }
                Object valueBean = this.getValue(prop.value);
                PropertyUtils.setProperty((Object)this.object_, (String)prop.name, (Object)valueBean);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    private void populateBeanInArray(Object bean, String name, String value) throws Exception {
        int idx = name.lastIndexOf("[");
        String arrayBeanName = name.substring(0, idx);
        int index = Integer.parseInt(name.substring(idx + 1, name.length() - 1));
        Object arrayBean = PropertyUtils.getProperty((Object)bean, (String)arrayBeanName);
        if (arrayBean instanceof List) {
            List list = (List)arrayBean;
            Object valueBean = this.getValue(value);
            if (list.size() == index) {
                list.add(valueBean);
            } else {
                list.set(index, valueBean);
            }
        } else if (arrayBean instanceof Collection) {
            Collection c = (Collection)arrayBean;
            Object valueBean = this.getValue(value);
            c.add(valueBean);
        } else {
            Object[] array = (Object[])arrayBean;
            array[index] = this.getValue(value);
        }
    }

    private Object getValue(String value) throws Exception {
        if (value.startsWith("#new")) {
            String[] temp = value.split(" ");
            String className = temp[1];
            if (className.indexOf(".") < 0) {
                StringBuilder fullName = new StringBuilder();
                fullName.append(this.package_);
                fullName.append(".");
                fullName.append(className);
                Class clazz = Tools.forName((String)fullName.toString(), (Object)this);
                return clazz.newInstance();
            }
        } else {
            if (value.startsWith("#int")) {
                String[] temp = value.split(" ");
                value = temp[1].trim();
                return new Integer(value);
            }
            if (value.startsWith("#long")) {
                String[] temp = value.split(" ");
                value = temp[1].trim();
                return new Long(value);
            }
            if (value.startsWith("#boolean")) {
                String[] temp = value.split(" ");
                value = temp[1].trim();
                return new Boolean("true".equals(value));
            }
        }
        return value;
    }

    public void addProperty(Object value) {
        this.properties_.add(value);
    }

    public Iterator getPropertyIterator() {
        return this.properties_.iterator();
    }
}

