/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.context;

import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import org.exoplatform.container.component.ThreadContext;
import org.exoplatform.container.component.ThreadContextHolder;
import org.exoplatform.container.context.AdvancedContext;
import org.exoplatform.container.context.CreationContext;
import org.exoplatform.container.context.CreationContextStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext<K>
implements AdvancedContext<K>,
ThreadContextHolder {
    private final ThreadLocal<CreationContextStorage> storage = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        void var5_10;
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        String id = this.getId(contextual);
        CreationContextStorage storage = this.getStorage();
        T t = this.getInstance(storage, id);
        if (t != null) return var5_10;
        if (creationalContext == null) {
            return null;
        }
        if (this.isSharable()) {
            Lock lock = this.getLock(id);
            try {
                lock.lock();
                T t2 = this.getInstance(storage, id);
                if (t2 != null) return var5_10;
                Object object = storage.setInstance(id, new CreationContext<Object>(contextual, creationalContext, contextual.create(creationalContext)));
                return var5_10;
            }
            finally {
                lock.unlock();
            }
        } else {
            Object object = storage.setInstance(id, new CreationContext<Object>(contextual, creationalContext, contextual.create(creationalContext)));
        }
        return var5_10;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public void destroy(Contextual contextual) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        String id = this.getId(contextual);
        CreationContextStorage storage = this.getStorage();
        CreationContext creationContext = storage.getCreationContext(id);
        if (creationContext != null) {
            if (creationContext.getInstance() != null && creationContext.getCreationalContext() != null) {
                contextual.destroy(creationContext.getInstance(), creationContext.getCreationalContext());
            }
            storage.removeInstance(id);
        }
    }

    public boolean isActive() {
        return this.storage.get() != null;
    }

    @Override
    public void activate(K key) {
        this.setStorage(this.createStorage(key));
    }

    @Override
    public void deactivate(K key) {
        this.setStorage(null);
    }

    @Override
    public void register(K key) {
    }

    @Override
    public void unregister(K key) {
        this.destroy(this.createStorage(key));
    }

    protected <T> String getId(Contextual<T> contextual) {
        if (contextual instanceof PassivationCapable) {
            return ((PassivationCapable)contextual).getId();
        }
        throw new UnsupportedOperationException("Only contextuals that implement the PassivationCapable interface are supported");
    }

    protected abstract boolean isSharable();

    protected abstract Lock getLock(String var1);

    protected abstract CreationContextStorage createStorage(K var1);

    protected CreationContextStorage getStorage() {
        return this.storage.get();
    }

    protected void setStorage(CreationContextStorage storage) {
        if (storage == null) {
            this.storage.remove();
        } else {
            this.storage.set(storage);
        }
    }

    protected void destroy() {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        CreationContextStorage storage = this.getStorage();
        this.destroy(storage);
    }

    protected void destroy(CreationContextStorage storage) {
        Set<String> ids = storage.getAllIds();
        if (ids != null) {
            for (String id : ids) {
                CreationContext creationContext = storage.getCreationContext(id);
                if (creationContext == null) continue;
                if (creationContext.getContextual() != null && creationContext.getInstance() != null && creationContext.getCreationalContext() != null) {
                    creationContext.getContextual().destroy(creationContext.getInstance(), creationContext.getCreationalContext());
                }
                storage.removeInstance(id);
            }
        }
    }

    protected <T> T getInstance(CreationContextStorage storage, String id) {
        CreationContext creationContext = storage.getCreationContext(id);
        return creationContext == null ? null : (T)creationContext.getInstance();
    }

    @Override
    public ThreadContext getThreadContext() {
        return new ThreadContext(this.storage);
    }
}

