/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.context;

import java.lang.annotation.Annotation;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.context.CreationContext;
import org.exoplatform.container.context.CreationContextStorage;
import org.exoplatform.container.context.SharedContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionContext
extends SharedContext<HttpSession> {
    public Class<? extends Annotation> getScope() {
        return SessionScoped.class;
    }

    @Override
    protected CreationContextStorage createStorage(HttpSession key) {
        return new SessionContextStorage(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SessionContextStorage
    implements CreationContextStorage {
        private static final String PREFIX = SessionContextStorage.class.getPackage().getName();
        private final HttpSession session;

        public SessionContextStorage(HttpSession session) {
            this.session = session;
        }

        private String getFullId(String id) {
            StringBuilder sb = new StringBuilder(PREFIX);
            sb.append('#');
            sb.append(id);
            return sb.toString();
        }

        @Override
        public String getId() {
            return this.session.getId();
        }

        @Override
        public <T> T setInstance(String id, CreationContext<T> creationContext) {
            String fullId = this.getFullId(id);
            CreationContext currentValue = (CreationContext)this.session.getAttribute(fullId);
            if (currentValue != null && currentValue.getInstance() != null) {
                return currentValue.getInstance();
            }
            this.session.setAttribute(fullId, creationContext);
            return creationContext.getInstance();
        }

        @Override
        public <T> CreationContext<T> getCreationContext(String id) {
            String fullId = this.getFullId(id);
            return (CreationContext)this.session.getAttribute(fullId);
        }

        @Override
        public void removeInstance(String id) {
            String fullId = this.getFullId(id);
            this.session.removeAttribute(fullId);
        }

        @Override
        public Set<String> getAllIds() {
            Enumeration enumeration = this.session.getAttributeNames();
            HashSet<String> ids = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                String id = (String)enumeration.nextElement();
                if (!id.startsWith(PREFIX)) continue;
                ids.add(id.substring(PREFIX.length() + 1));
            }
            return ids;
        }
    }
}

