/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentLifecyclePlugin;
import org.exoplatform.container.xml.ContainerLifecyclePlugin;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.JiBX_bindingMungeAdapter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Cloneable,
IUnmarshallable,
IMarshallable {
    public static final String KERNEL_CONFIGURATION_1_0_URI = "http://www.exoplaform.org/xml/ns/kernel_1_0.xsd";
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.Configuration");
    private Map<String, ContainerLifecyclePlugin> containerLifecyclePlugin_ = new HashMap<String, ContainerLifecyclePlugin>();
    private Map<String, ComponentLifecyclePlugin> componentLifecyclePlugin_ = new HashMap<String, ComponentLifecyclePlugin>();
    private Map<String, Component> component_ = new HashMap<String, Component>();
    private Map<String, ExternalComponentPlugins> externalComponentPlugins_ = new HashMap<String, ExternalComponentPlugins>();
    private List<String> imports_;
    private List<String> removeConfiguration_;
    private int currentSize;
    private int currentHash;
    public static final String JiBX_bindingList = "|org.exoplatform.container.xml.JiBX_bindingFactory|";

    public Collection<ContainerLifecyclePlugin> getContainerLifecyclePlugins() {
        ArrayList<ContainerLifecyclePlugin> plugins = new ArrayList<ContainerLifecyclePlugin>(this.containerLifecyclePlugin_.values());
        Collections.sort(plugins);
        return plugins;
    }

    public void addContainerLifecyclePlugin(ContainerLifecyclePlugin plugin) {
        String key = plugin.getType();
        this.containerLifecyclePlugin_.put(key, plugin);
    }

    public Iterator<ContainerLifecyclePlugin> getContainerLifecyclePluginIterator() {
        return this.getContainerLifecyclePlugins().iterator();
    }

    public boolean hasContainerLifecyclePlugin() {
        return this.containerLifecyclePlugin_.size() > 0;
    }

    public Collection<ComponentLifecyclePlugin> getComponentLifecyclePlugins() {
        return this.componentLifecyclePlugin_.values();
    }

    public void addComponentLifecyclePlugin(Object object) {
        ComponentLifecyclePlugin plugin = (ComponentLifecyclePlugin)object;
        String key = plugin.getType();
        this.componentLifecyclePlugin_.put(key, plugin);
    }

    public Iterator<ComponentLifecyclePlugin> getComponentLifecyclePluginIterator() {
        return this.componentLifecyclePlugin_.values().iterator();
    }

    public boolean hasComponentLifecyclePlugin() {
        return this.componentLifecyclePlugin_.size() > 0;
    }

    public Component getComponent(String s) {
        return this.component_.get(s);
    }

    public void addComponent(Component comp) {
        String key = comp.getKey();
        if (key == null) {
            key = comp.getType();
            comp.setKey(key);
        }
        this.component_.put(key, comp);
    }

    public Collection<Component> getComponents() {
        return this.component_.values();
    }

    public Iterator<Component> getComponentIterator() {
        return this.component_.values().iterator();
    }

    public boolean hasComponent() {
        return this.component_.size() > 0;
    }

    public ExternalComponentPlugins getExternalComponentPlugins(String s) {
        return this.externalComponentPlugins_.get(s);
    }

    public void addExternalComponentPlugins(ExternalComponentPlugins eps) {
        String targetComponent = eps.getTargetComponent();
        ExternalComponentPlugins foundExternalComponentPlugins = this.externalComponentPlugins_.get(targetComponent);
        if (foundExternalComponentPlugins == null) {
            this.externalComponentPlugins_.put(targetComponent, eps);
        } else {
            foundExternalComponentPlugins.merge(eps);
        }
    }

    public Iterator<ExternalComponentPlugins> getExternalComponentPluginsIterator() {
        return this.externalComponentPlugins_.values().iterator();
    }

    public boolean hasExternalComponentPlugins() {
        return this.externalComponentPlugins_.size() > 0;
    }

    public void addImport(String url) {
        if (this.imports_ == null) {
            this.imports_ = new ArrayList<String>();
        }
        this.imports_.add(url);
    }

    public List<String> getImports() {
        return this.imports_;
    }

    public void addRemoveConfiguration(String type) {
        if (this.removeConfiguration_ == null) {
            this.removeConfiguration_ = new ArrayList<String>();
        }
        this.removeConfiguration_.add(type);
    }

    public List<String> getRemoveConfiguration() {
        return this.removeConfiguration_;
    }

    public void removeConfiguration(String type) {
        this.component_.remove(type);
    }

    public void mergeConfiguration(Configuration other) {
        this.component_.putAll(other.component_);
        this.componentLifecyclePlugin_.putAll(other.componentLifecyclePlugin_);
        this.containerLifecyclePlugin_.putAll(other.containerLifecyclePlugin_);
        Iterator<ExternalComponentPlugins> i = other.externalComponentPlugins_.values().iterator();
        while (i.hasNext()) {
            this.addExternalComponentPlugins(i.next());
        }
        if (other.getRemoveConfiguration() == null) {
            return;
        }
        if (this.removeConfiguration_ == null) {
            this.removeConfiguration_ = new ArrayList<String>();
        }
        this.removeConfiguration_.addAll(other.getRemoveConfiguration());
    }

    public static Configuration merge(Configuration ... configs) {
        if (configs == null || configs.length == 0) {
            return null;
        }
        Configuration result = null;
        for (Configuration conf : configs) {
            if (conf == null) continue;
            if (result == null) {
                result = (Configuration)conf.clone();
                continue;
            }
            result.mergeConfiguration(conf);
        }
        return result;
    }

    protected Object clone() {
        try {
            Configuration conf = (Configuration)super.clone();
            conf.component_ = (Map)((HashMap)this.component_).clone();
            conf.componentLifecyclePlugin_ = (Map)((HashMap)this.componentLifecyclePlugin_).clone();
            conf.containerLifecyclePlugin_ = (Map)((HashMap)this.containerLifecyclePlugin_).clone();
            conf.externalComponentPlugins_ = (Map)((HashMap)this.externalComponentPlugins_).clone();
            if (this.imports_ != null) {
                conf.imports_ = (List)((ArrayList)this.imports_).clone();
            }
            if (this.removeConfiguration_ != null) {
                conf.removeConfiguration_ = (List)((ArrayList)this.removeConfiguration_).clone();
            }
            return conf;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"Could not clone the configuration");
        }
    }

    public void toXML(Writer w) {
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(Configuration.class);
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument((Object)this, "UTF-8", null, w);
        }
        catch (Exception e) {
            LOG.warn((Object)"Couldn't dump the runtime configuration in XML Format", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringWriter sw = new StringWriter();
        try {
            this.toXML(sw);
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot convert the configuration to XML format", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            block12: {
                try {
                    sw.close();
                }
                catch (IOException ignore) {
                    if (!LOG.isTraceEnabled()) break block12;
                    LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
                }
            }
        }
        return sw.toString();
    }

    public void keepCurrentState() {
        String xml = this.toXML();
        if (xml != null) {
            this.currentSize = xml.length();
            this.currentHash = xml.hashCode();
        }
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public int getCurrentHash() {
        return this.currentHash;
    }

    public static /* synthetic */ Configuration JiBX_binding_newinstance_1_0(Configuration arg1, UnmarshallingContext arg2) throws JiBXException {
        if (arg1 == null) {
            arg1 = new Configuration();
        }
        return arg1;
    }

    public static /* synthetic */ Configuration JiBX_binding_unmarshal_1_0(Configuration arg1, UnmarshallingContext arg2) throws JiBXException {
        arg2.pushTrackedObject((Object)arg1);
        Configuration configuration = arg1;
        while (arg2.getUnmarshaller("org.exoplatform.container.xml.ContainerLifecyclePlugin").isPresent((IUnmarshallingContext)arg2)) {
            arg1.addContainerLifecyclePlugin((ContainerLifecyclePlugin)arg2.getUnmarshaller("org.exoplatform.container.xml.ContainerLifecyclePlugin").unmarshal(null, (IUnmarshallingContext)arg2));
        }
        while (arg2.getUnmarshaller("org.exoplatform.container.xml.ComponentLifecyclePlugin").isPresent((IUnmarshallingContext)arg2)) {
            arg1.addComponentLifecyclePlugin((ComponentLifecyclePlugin)arg2.getUnmarshaller("org.exoplatform.container.xml.ComponentLifecyclePlugin").unmarshal(null, (IUnmarshallingContext)arg2));
        }
        while (arg2.getUnmarshaller("org.exoplatform.container.xml.Component").isPresent((IUnmarshallingContext)arg2)) {
            arg1.addComponent((Component)arg2.getUnmarshaller("org.exoplatform.container.xml.Component").unmarshal(null, (IUnmarshallingContext)arg2));
        }
        while (arg2.getUnmarshaller("org.exoplatform.container.xml.ExternalComponentPlugins").isPresent((IUnmarshallingContext)arg2)) {
            arg1.addExternalComponentPlugins((ExternalComponentPlugins)arg2.getUnmarshaller("org.exoplatform.container.xml.ExternalComponentPlugins").unmarshal(null, (IUnmarshallingContext)arg2));
        }
        arg1.imports_ = !JiBX_bindingMungeAdapter.JiBX_binding_test_1_5(arg2) ? null : JiBX_bindingMungeAdapter.JiBX_binding_unmarshal_1_5(JiBX_bindingMungeAdapter.JiBX_binding_newinstance_1_0(arg1.imports_, arg2), arg2);
        arg1.removeConfiguration_ = !JiBX_bindingMungeAdapter.JiBX_binding_test_1_6(arg2) ? null : JiBX_bindingMungeAdapter.JiBX_binding_unmarshal_1_6(JiBX_bindingMungeAdapter.JiBX_binding_newinstance_1_0(arg1.removeConfiguration_, arg2), arg2);
        arg2.popObject();
        return arg1;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.container.xml.Configuration").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.container.xml.Configuration";
    }

    public static /* synthetic */ void JiBX_binding_marshal_1_0(Configuration arg1, MarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        MarshallingContext marshallingContext = arg2;
        if (arg1.hasContainerLifecyclePlugin()) {
            Iterator<ContainerLifecyclePlugin> var0 = arg1.getContainerLifecyclePluginIterator();
            while (var0.hasNext()) {
                arg2.getMarshaller("org.exoplatform.container.xml.ContainerLifecyclePlugin").marshal((Object)var0.next(), (IMarshallingContext)arg2);
            }
        }
        if (arg1.hasComponentLifecyclePlugin()) {
            Iterator<ComponentLifecyclePlugin> var0 = arg1.getComponentLifecyclePluginIterator();
            while (var0.hasNext()) {
                arg2.getMarshaller("org.exoplatform.container.xml.ComponentLifecyclePlugin").marshal((Object)var0.next(), (IMarshallingContext)arg2);
            }
        }
        if (arg1.hasComponent()) {
            Iterator<Component> var0 = arg1.getComponentIterator();
            while (var0.hasNext()) {
                arg2.getMarshaller("org.exoplatform.container.xml.Component").marshal((Object)var0.next(), (IMarshallingContext)arg2);
            }
        }
        if (arg1.hasExternalComponentPlugins()) {
            Iterator<ExternalComponentPlugins> var0 = arg1.getExternalComponentPluginsIterator();
            while (var0.hasNext()) {
                arg2.getMarshaller("org.exoplatform.container.xml.ExternalComponentPlugins").marshal((Object)var0.next(), (IMarshallingContext)arg2);
            }
        }
        List<String> list = arg1.imports_;
        if (list != null) {
            JiBX_bindingMungeAdapter.JiBX_binding_marshal_1_6(list, arg2);
        }
        List<String> list2 = arg1.removeConfiguration_;
        if (list2 != null) {
            JiBX_bindingMungeAdapter.JiBX_binding_marshal_1_7(list2, arg2);
        }
        arg2.popObject();
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.container.xml.Configuration").marshal((Object)this, arg1);
    }
}

