/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.exoplatform.container.jmx.AbstractExoMBeanTest;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;

public class TestExoMBeanAttribute
extends AbstractExoMBeanTest {
    public void test1() throws Exception {
        this.test1(this.register("domain:name=mbean0", MBean1_0.class), "getString");
        this.test1(this.register("domain:name=mbean1", MBean1_1.class), "getString");
        this.test1(this.register("domain:name=mbean2", MBean1_2.class), "getInteger");
    }

    private void test1(AbstractExoMBeanTest.Bean bean, String getterName) throws Exception {
        MBeanOperationInfo[] operationInfos = bean.info.getOperations();
        TestExoMBeanAttribute.assertNotNull((Object)operationInfos);
        TestExoMBeanAttribute.assertEquals((int)1, (int)operationInfos.length);
        MBeanOperationInfo operationInfo = operationInfos[0];
        TestExoMBeanAttribute.assertNotNull((Object)operationInfo);
        TestExoMBeanAttribute.assertEquals((String)getterName, (String)operationInfo.getName());
        TestExoMBeanAttribute.assertEquals((String)"java.lang.String", (String)operationInfo.getReturnType());
        TestExoMBeanAttribute.assertEquals((int)0, (int)operationInfo.getSignature().length);
        MBeanAttributeInfo[] attributeInfos = bean.info.getAttributes();
        TestExoMBeanAttribute.assertNotNull((Object)attributeInfos);
        TestExoMBeanAttribute.assertEquals((int)1, (int)attributeInfos.length);
        MBeanAttributeInfo attributeInfo = attributeInfos[0];
        TestExoMBeanAttribute.assertEquals((String)"String", (String)attributeInfo.getName());
        TestExoMBeanAttribute.assertEquals((String)"java.lang.String", (String)attributeInfo.getType());
        TestExoMBeanAttribute.assertEquals((boolean)true, (boolean)attributeInfo.isReadable());
        TestExoMBeanAttribute.assertEquals((boolean)false, (boolean)attributeInfo.isWritable());
        MBean1_0.string = "Foo";
        TestExoMBeanAttribute.assertEquals((Object)"Foo", (Object)this.server.invoke(bean.name, getterName, new Object[0], new String[0]));
        MBean1_0.string = "Bar";
        TestExoMBeanAttribute.assertEquals((Object)"Bar", (Object)this.server.getAttribute(bean.name, "String"));
    }

    public void test2() throws Exception {
        this.test2(this.register("domain:name=mbean0", MBean2_0.class), "setString");
        this.test2(this.register("domain:name=mbean1", MBean2_1.class), "setString");
        this.test2(this.register("domain:name=mbean2", MBean2_2.class), "setInteger");
    }

    public void test2(AbstractExoMBeanTest.Bean bean, String setterName) throws Exception {
        MBeanOperationInfo[] operationInfos = bean.info.getOperations();
        TestExoMBeanAttribute.assertNotNull((Object)operationInfos);
        TestExoMBeanAttribute.assertEquals((int)1, (int)operationInfos.length);
        MBeanOperationInfo operationInfo = operationInfos[0];
        TestExoMBeanAttribute.assertNotNull((Object)operationInfo);
        TestExoMBeanAttribute.assertEquals((String)setterName, (String)operationInfo.getName());
        TestExoMBeanAttribute.assertEquals((String)"void", (String)operationInfo.getReturnType());
        MBeanParameterInfo[] attributeParameterInfos = operationInfo.getSignature();
        TestExoMBeanAttribute.assertEquals((int)1, (int)attributeParameterInfos.length);
        MBeanParameterInfo attributeParameterInfo = attributeParameterInfos[0];
        TestExoMBeanAttribute.assertEquals((String)"java.lang.String", (String)attributeParameterInfo.getType());
        MBeanAttributeInfo[] attributeInfos = bean.info.getAttributes();
        TestExoMBeanAttribute.assertNotNull((Object)attributeInfos);
        TestExoMBeanAttribute.assertEquals((int)1, (int)attributeInfos.length);
        MBeanAttributeInfo attributeInfo = attributeInfos[0];
        TestExoMBeanAttribute.assertEquals((String)"String", (String)attributeInfo.getName());
        TestExoMBeanAttribute.assertEquals((String)"java.lang.String", (String)attributeInfo.getType());
        TestExoMBeanAttribute.assertEquals((boolean)false, (boolean)attributeInfo.isReadable());
        TestExoMBeanAttribute.assertEquals((boolean)true, (boolean)attributeInfo.isWritable());
        MBean2_0.string = null;
        TestExoMBeanAttribute.assertEquals(null, (Object)this.server.invoke(bean.name, setterName, new Object[]{"Foo"}, new String[]{"java.lang.String"}));
        TestExoMBeanAttribute.assertEquals((String)"Foo", (String)MBean2_0.string);
        this.server.setAttribute(bean.name, new Attribute("String", "Bar"));
        TestExoMBeanAttribute.assertEquals((String)"Bar", (String)MBean2_0.string);
    }

    public void test3() throws Exception {
        this.test3(this.register("domain:name=mbean0", MBean3_0.class), "getString", "setString");
        this.test3(this.register("domain:name=mbean1", MBean3_1.class), "getInteger", "setInteger");
        this.test3(this.register("domain:name=mbean2", MBean3_2.class), "getInteger", "setInteger");
        this.test3(this.register("domain:name=mbean3", MBean3_3.class), "getInteger", "setInteger");
    }

    public void test3(AbstractExoMBeanTest.Bean bean, String getterName, String setterName) throws Exception {
        MBeanOperationInfo[] operationInfos = bean.info.getOperations();
        TestExoMBeanAttribute.assertNotNull((Object)operationInfos);
        TestExoMBeanAttribute.assertEquals((int)2, (int)operationInfos.length);
        ModelMBeanOperationInfo setStringInfo = bean.info.getOperation(setterName);
        TestExoMBeanAttribute.assertNotNull((Object)setStringInfo);
        TestExoMBeanAttribute.assertEquals((String)setterName, (String)setStringInfo.getName());
        TestExoMBeanAttribute.assertEquals((String)"void", (String)setStringInfo.getReturnType());
        MBeanParameterInfo[] setStringParameterInfos = setStringInfo.getSignature();
        TestExoMBeanAttribute.assertEquals((int)1, (int)setStringParameterInfos.length);
        MBeanParameterInfo attributeParameterInfo = setStringParameterInfos[0];
        TestExoMBeanAttribute.assertEquals((String)"java.lang.String", (String)attributeParameterInfo.getType());
        ModelMBeanOperationInfo getStringInfo = bean.info.getOperation(getterName);
        TestExoMBeanAttribute.assertNotNull((Object)getStringInfo);
        TestExoMBeanAttribute.assertEquals((String)getterName, (String)getStringInfo.getName());
        TestExoMBeanAttribute.assertEquals((String)"java.lang.String", (String)getStringInfo.getReturnType());
        TestExoMBeanAttribute.assertEquals((int)0, (int)getStringInfo.getSignature().length);
        MBeanAttributeInfo[] attributeInfos = bean.info.getAttributes();
        TestExoMBeanAttribute.assertNotNull((Object)attributeInfos);
        TestExoMBeanAttribute.assertEquals((int)1, (int)attributeInfos.length);
        MBeanAttributeInfo attributeInfo = attributeInfos[0];
        TestExoMBeanAttribute.assertEquals((String)"String", (String)attributeInfo.getName());
        TestExoMBeanAttribute.assertEquals((String)"java.lang.String", (String)attributeInfo.getType());
        TestExoMBeanAttribute.assertEquals((boolean)true, (boolean)attributeInfo.isReadable());
        TestExoMBeanAttribute.assertEquals((boolean)true, (boolean)attributeInfo.isWritable());
        MBean3_0.string = null;
        TestExoMBeanAttribute.assertEquals(null, (Object)this.server.invoke(bean.name, setterName, new Object[]{"Foo"}, new String[]{"java.lang.String"}));
        TestExoMBeanAttribute.assertEquals((String)"Foo", (String)MBean3_0.string);
        this.server.setAttribute(bean.name, new Attribute("String", "Bar"));
        TestExoMBeanAttribute.assertEquals((String)"Bar", (String)MBean3_0.string);
        MBean3_0.string = "Juu";
        TestExoMBeanAttribute.assertEquals((Object)"Juu", (Object)this.server.invoke(bean.name, getterName, new Object[0], new String[0]));
        MBean3_0.string = "Daa";
        TestExoMBeanAttribute.assertEquals((Object)"Daa", (Object)this.server.getAttribute(bean.name, "String"));
    }

    public void test4() throws Exception {
        this.assertNotBuildable(MBean4_0.class);
        this.assertNotBuildable(MBean4_1.class);
        this.assertNotBuildable(MBean4_2.class);
        this.assertNotBuildable(MBean4_3.class);
    }

    public void test5() throws Exception {
        this.test5(this.register("domain:name=mbean0", MBean5_0.class));
        this.test5(this.register("domain:name=mbean1", MBean5_1.class));
    }

    public void test5(AbstractExoMBeanTest.Bean bean) throws Exception {
        MBeanAttributeInfo[] attributeInfos = bean.info.getAttributes();
        TestExoMBeanAttribute.assertNotNull((Object)attributeInfos);
        TestExoMBeanAttribute.assertEquals((int)1, (int)attributeInfos.length);
        MBeanAttributeInfo attributeInfo = attributeInfos[0];
        TestExoMBeanAttribute.assertEquals((String)"String", (String)attributeInfo.getName());
        TestExoMBeanAttribute.assertEquals((String)"String_description", (String)attributeInfo.getDescription());
        TestExoMBeanAttribute.assertEquals((String)"java.lang.String", (String)attributeInfo.getType());
    }

    public void test6() throws Exception {
        this.test6(this.register("domain:name=mbean0", MBean6_0.class), "Name");
        this.test6(this.register("domain:name=mbean1", MBean6_1.class), "Foo");
        this.test6(this.register("domain:name=mbean2", MBean6_2.class), "Bar");
        this.test6(this.register("domain:name=mbean3", MBean6_3.class), "Juu");
    }

    private void test6(AbstractExoMBeanTest.Bean bean, String expectedName) throws Exception {
        MBeanAttributeInfo[] attributeInfos = bean.info.getAttributes();
        TestExoMBeanAttribute.assertEquals((int)1, (int)attributeInfos.length);
        MBeanAttributeInfo attributeInfo = attributeInfos[0];
        TestExoMBeanAttribute.assertEquals((String)expectedName, (String)attributeInfo.getName());
    }

    public void test7() throws Exception {
        this.test7(this.register("domain:name=mbean0", MBean7_0.class), "Name");
        this.test7(this.register("domain:name=mbean1", MBean7_1.class), "Foo");
        this.test7(this.register("domain:name=mbean2", MBean7_2.class), "Bar");
        this.test7(this.register("domain:name=mbean3", MBean7_3.class), "Juu");
    }

    private void test7(AbstractExoMBeanTest.Bean bean, String expectedName) throws Exception {
        MBeanAttributeInfo[] attributeInfos = bean.info.getAttributes();
        TestExoMBeanAttribute.assertEquals((int)1, (int)attributeInfos.length);
        MBeanAttributeInfo attributeInfo = attributeInfos[0];
        TestExoMBeanAttribute.assertEquals((String)expectedName, (String)attributeInfo.getName());
    }

    @Managed
    public static class MBean7_3
    extends SuperMBean7_3 {
        @ManagedName(value="Juu")
        public String getName() {
            return "Foo";
        }
    }

    public static class SuperMBean7_3 {
        @Managed
        @ManagedName(value="Foo")
        public String getName() {
            return "Foo";
        }
    }

    @Managed
    public static class MBean7_2
    extends SuperMBean7_2 {
        @ManagedName(value="Bar")
        public String getName() {
            return "Foo";
        }
    }

    public static class SuperMBean7_2 {
        @Managed
        public String getName() {
            return "Foo";
        }
    }

    @Managed
    public static class MBean7_1
    extends SuperMBean7_1 {
        public String getName() {
            return "Foo";
        }
    }

    public static class SuperMBean7_1 {
        @Managed
        @ManagedName(value="Foo")
        public String getName() {
            return "Foo";
        }
    }

    @Managed
    public static class MBean7_0
    extends SuperMBean7_0 {
        public String getName() {
            return "Foo";
        }
    }

    public static class SuperMBean7_0 {
        @Managed
        public String getName() {
            return "Foo";
        }
    }

    @Managed
    public static class MBean6_3
    implements Interface6_3 {
        @ManagedName(value="Juu")
        public String getName() {
            return "Foo";
        }
    }

    public static interface Interface6_3 {
        @Managed
        @ManagedName(value="Foo")
        public String getName();
    }

    @Managed
    public static class MBean6_2
    implements Interface6_2 {
        @ManagedName(value="Bar")
        public String getName() {
            return "Foo";
        }
    }

    public static interface Interface6_2 {
        @Managed
        public String getName();
    }

    @Managed
    public static class MBean6_1
    implements Interface6_1 {
        public String getName() {
            return "Foo";
        }
    }

    public static interface Interface6_1 {
        @Managed
        @ManagedName(value="Foo")
        public String getName();
    }

    @Managed
    public static class MBean6_0
    implements Interface6_0 {
        public String getName() {
            return "Foo";
        }
    }

    public static interface Interface6_0 {
        @Managed
        public String getName();
    }

    @Managed
    public static class MBean5_2 {
        @Managed
        @ManagedDescription(value="String_description")
        public void setString(String string) {
        }

        @Managed
        @ManagedDescription(value="String_description 2")
        public String getString() {
            return null;
        }
    }

    @Managed
    public static class MBean5_1 {
        @Managed
        @ManagedDescription(value="String_description")
        public void setString(String string) {
        }
    }

    @Managed
    public static class MBean5_0 {
        @Managed
        @ManagedDescription(value="String_description")
        public String getString() {
            return null;
        }
    }

    @Managed
    public static class MBean4_3 {
        @Managed
        @ManagedName(value="Integer")
        public Integer getInteger() {
            return null;
        }

        @Managed
        @ManagedName(value="Integer")
        public String getString() {
            return null;
        }
    }

    @Managed
    public static class MBean4_2 {
        @Managed
        @ManagedName(value="Integer")
        public void setInteger(String s) {
        }

        @Managed
        @ManagedName(value="Integer")
        public void setString(Integer s) {
        }
    }

    @Managed
    public static class MBean4_1 {
        @Managed
        public void setInteger(String s) {
        }

        @Managed
        public void setInteger(Integer s) {
        }
    }

    @Managed
    public static class MBean4_0 {
        @Managed
        @ManagedName(value="String")
        public String getInteger() {
            return null;
        }

        @Managed
        @ManagedName(value="Integer")
        public void setInteger(String s) {
        }
    }

    @Managed
    public static class MBean3_3 {
        @Managed
        @ManagedName(value="String")
        public String getInteger() {
            return MBean3_0.string;
        }

        @Managed
        @ManagedName(value="String")
        public void setInteger(String s) {
            MBean3_0.string = s;
        }
    }

    @Managed
    public static class MBean3_2 {
        @Managed
        public String getInteger() {
            return MBean3_0.string;
        }

        @Managed
        @ManagedName(value="String")
        public void setInteger(String s) {
            MBean3_0.string = s;
        }
    }

    @Managed
    public static class MBean3_1 {
        @Managed
        @ManagedName(value="String")
        public String getInteger() {
            return MBean3_0.string;
        }

        @Managed
        public void setInteger(String s) {
            MBean3_0.string = s;
        }
    }

    @Managed
    public static class MBean3_0 {
        static String string;

        @Managed
        public String getString() {
            return string;
        }

        @Managed
        public void setString(String s) {
            string = s;
        }
    }

    @Managed
    public static class MBean2_2 {
        @Managed
        @ManagedName(value="String")
        public void setInteger(String s) {
            MBean2_0.string = s;
        }
    }

    @Managed
    public static class MBean2_1 {
        @Managed
        public void setString(String s) {
            MBean2_0.string = s;
        }

        public String getString() {
            return MBean2_0.string;
        }
    }

    @Managed
    public static class MBean2_0 {
        static String string;

        @Managed
        public void setString(String s) {
            string = s;
        }
    }

    @Managed
    public static class MBean1_2 {
        @Managed
        @ManagedName(value="String")
        public String getInteger() {
            return MBean1_0.string;
        }
    }

    @Managed
    public static class MBean1_1 {
        public void setString(String s) {
            MBean1_0.string = s;
        }

        @Managed
        public String getString() {
            return MBean1_0.string;
        }
    }

    @Managed
    public static class MBean1_0 {
        static String string;

        @Managed
        public String getString() {
            return string;
        }
    }
}

