/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import junit.framework.TestCase;
import org.exoplatform.container.UnifiedClassLoader;

public class TestUnifiedClassLoader
extends TestCase {
    public void testConstructor() {
        try {
            UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[0]);
            TestUnifiedClassLoader.fail((String)"An IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[0]);
            TestUnifiedClassLoader.fail((String)"An IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetResource() throws Exception {
        UnifiedClassLoader mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(null, null), new MockClassLoader(null, null)});
        TestUnifiedClassLoader.assertNull((Object)mcl.getResource(null));
        URL result = new URL("file:///foo");
        mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(null, null), new MockClassLoader(result, null)});
        TestUnifiedClassLoader.assertEquals((Object)result, (Object)mcl.getResource(null));
        mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(result, null), new MockClassLoader(null, null)});
        TestUnifiedClassLoader.assertEquals((Object)result, (Object)mcl.getResource(null));
        mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(new URL("file:///foo2"), null), new MockClassLoader(result, null)});
        TestUnifiedClassLoader.assertEquals((Object)result, (Object)mcl.getResource(null));
    }

    public void testGetResources() throws Exception {
        UnifiedClassLoader mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(null, Collections.enumeration(new ArrayList())), new MockClassLoader(null, Collections.enumeration(new ArrayList()))});
        Enumeration eResult = mcl.getResources(null);
        TestUnifiedClassLoader.assertNotNull((Object)eResult);
        TestUnifiedClassLoader.assertFalse((boolean)eResult.hasMoreElements());
        mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(null, null), new MockClassLoader(null, null)});
        eResult = mcl.getResources(null);
        TestUnifiedClassLoader.assertNotNull((Object)eResult);
        TestUnifiedClassLoader.assertFalse((boolean)eResult.hasMoreElements());
        URL result = new URL("file:///foo");
        mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(null, Collections.enumeration(Arrays.asList(result))), new MockClassLoader(null, Collections.enumeration(new ArrayList()))});
        eResult = mcl.getResources(null);
        TestUnifiedClassLoader.assertNotNull((Object)eResult);
        TestUnifiedClassLoader.assertTrue((boolean)eResult.hasMoreElements());
        TestUnifiedClassLoader.assertEquals((Object)result, eResult.nextElement());
        TestUnifiedClassLoader.assertFalse((boolean)eResult.hasMoreElements());
        mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(null, Collections.enumeration(Arrays.asList(result))), new MockClassLoader(null, null)});
        eResult = mcl.getResources(null);
        TestUnifiedClassLoader.assertNotNull((Object)eResult);
        TestUnifiedClassLoader.assertTrue((boolean)eResult.hasMoreElements());
        TestUnifiedClassLoader.assertEquals((Object)result, eResult.nextElement());
        TestUnifiedClassLoader.assertFalse((boolean)eResult.hasMoreElements());
        mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(null, Collections.enumeration(new ArrayList())), new MockClassLoader(null, Collections.enumeration(Arrays.asList(result)))});
        eResult = mcl.getResources(null);
        TestUnifiedClassLoader.assertNotNull((Object)eResult);
        TestUnifiedClassLoader.assertTrue((boolean)eResult.hasMoreElements());
        TestUnifiedClassLoader.assertEquals((Object)result, eResult.nextElement());
        TestUnifiedClassLoader.assertFalse((boolean)eResult.hasMoreElements());
        mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(null, null), new MockClassLoader(null, Collections.enumeration(Arrays.asList(result)))});
        eResult = mcl.getResources(null);
        TestUnifiedClassLoader.assertNotNull((Object)eResult);
        TestUnifiedClassLoader.assertTrue((boolean)eResult.hasMoreElements());
        TestUnifiedClassLoader.assertEquals((Object)result, eResult.nextElement());
        TestUnifiedClassLoader.assertFalse((boolean)eResult.hasMoreElements());
        URL result1 = new URL("file:///foo");
        mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(null, Collections.enumeration(Arrays.asList(result))), new MockClassLoader(null, Collections.enumeration(Arrays.asList(result1)))});
        eResult = mcl.getResources(null);
        TestUnifiedClassLoader.assertNotNull((Object)eResult);
        TestUnifiedClassLoader.assertTrue((boolean)eResult.hasMoreElements());
        TestUnifiedClassLoader.assertEquals((Object)result, eResult.nextElement());
        TestUnifiedClassLoader.assertFalse((boolean)eResult.hasMoreElements());
        URL result2 = new URL("file:///foo2");
        mcl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode((ClassLoader[])new ClassLoader[]{new MockClassLoader(null, Collections.enumeration(Arrays.asList(result))), new MockClassLoader(null, Collections.enumeration(Arrays.asList(result2)))});
        eResult = mcl.getResources(null);
        TestUnifiedClassLoader.assertNotNull((Object)eResult);
        TestUnifiedClassLoader.assertTrue((boolean)eResult.hasMoreElements());
        TestUnifiedClassLoader.assertEquals((Object)result, eResult.nextElement());
        TestUnifiedClassLoader.assertTrue((boolean)eResult.hasMoreElements());
        TestUnifiedClassLoader.assertEquals((Object)result2, eResult.nextElement());
        TestUnifiedClassLoader.assertFalse((boolean)eResult.hasMoreElements());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockClassLoader
    extends ClassLoader {
        private final URL getResourceResult;
        private final Enumeration<URL> getResourcesResult;

        private MockClassLoader(URL getResourceResult, Enumeration<URL> getResourcesResult) {
            this.getResourceResult = getResourceResult;
            this.getResourcesResult = getResourcesResult;
        }

        @Override
        public URL getResource(String name) {
            return this.getResourceResult;
        }

        @Override
        public Enumeration<URL> getResources(String name) {
            return this.getResourcesResult;
        }
    }
}

