/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kernel.demos.mc;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.exoplatform.container.mc.impl.InterceptMC;
import org.exoplatform.container.mc.impl.MCInjectionMode;
import org.exoplatform.kernel.demos.mc.InjectedBean;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.beans.metadata.api.annotations.EntryValue;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.annotations.InstallMethod;
import org.jboss.beans.metadata.api.annotations.MapValue;
import org.jboss.beans.metadata.api.annotations.StringValue;
import org.jboss.beans.metadata.api.annotations.Value;
import org.jboss.dependency.spi.Controller;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterceptMC(injectionMode=MCInjectionMode.ALL)
public class InjectingBean
implements Startable {
    private static final Log log = ExoLogger.getLogger(InjectingBean.class);
    private InjectedBean bean;
    private KernelConfigurator configurator;
    @Inject(bean="InjectedBean")
    private InjectedBean injectedBean;
    private TransactionManager tm;
    private Map bindingsMap;
    private String stringValue;
    private int startCount;
    private boolean installOk;

    public InjectingBean() {
        log.info((Object)"Injecting bean instantiated");
    }

    public InjectedBean getBean() {
        return this.bean;
    }

    @Inject
    public void setBean(InjectedBean bean) {
        this.bean = bean;
        log.info((Object)("Received InjectedBean: " + bean));
    }

    public KernelConfigurator getConfigurator() {
        return this.configurator;
    }

    @Inject(bean="jboss.kernel:service=KernelConfigurator")
    public void setConfigurator(KernelConfigurator configurator) {
        this.configurator = configurator;
        log.info((Object)("InjectingBean Received KernelConfigurator: " + configurator));
    }

    public Map getBindings() {
        return this.bindingsMap;
    }

    @MapValue(value={@EntryValue(key=@Value(type=Class.class, string=@StringValue(value="org.jboss.dependency.spi.Controller", type=Class.class)), value=@Value(inject=@Inject(bean="jboss.kernel:service=KernelController"))), @EntryValue(key=@Value(type=Class.class, string=@StringValue(value="org.jboss.kernel.Kernel", type=Class.class)), value=@Value(inject=@Inject(bean="jboss.kernel:service=Kernel"))), @EntryValue(key=@Value(type=Class.class, string=@StringValue(value="org.jboss.kernel.spi.dependency.KernelController", type=Class.class)), value=@Value(inject=@Inject(bean="jboss.kernel:service=KernelController"))), @EntryValue(key=@Value(type=Class.class, string=@StringValue(value="org.jboss.kernel.spi.registry.KernelBus", type=Class.class)), value=@Value(inject=@Inject(bean="jboss.kernel:service=KernelBus"))), @EntryValue(key=@Value(type=Class.class, string=@StringValue(value="org.jboss.kernel.spi.registry.KernelRegistry", type=Class.class)), value=@Value(inject=@Inject(bean="jboss.kernel:service=KernelRegistry"))), @EntryValue(key=@Value(type=Class.class, string=@StringValue(value="org.jboss.kernel.spi.config.KernelConfigurator", type=Class.class)), value=@Value(inject=@Inject(bean="jboss.kernel:service=KernelConfigurator")))})
    public void setBindings(Map<Class<?>, Object> bindings) {
        log.info((Object)("Received a map with bindings: " + bindings));
        this.bindingsMap = bindings;
    }

    public String getSomeStringProperty() {
        return this.stringValue;
    }

    @Inject(bean="InjectedBean", property="someString")
    public void setSomeStringProperty(String value) {
        log.info((Object)("Received SomeStringProperty value: " + value));
        this.stringValue = value;
    }

    public void start() {
        log.warn((Object)("start() called (injectedBean is set to: " + this.injectedBean + ", transactionManager is setTo: " + this.tm + ")"));
        ++this.startCount;
    }

    public void stop() {
        log.info((Object)"stop() called");
    }

    public InjectedBean getInjectedBean() {
        return this.injectedBean;
    }

    public int getStartCount() {
        return this.startCount;
    }

    @Inject
    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    @InstallMethod
    public void initialize(@Inject @StringValue(value="parameter1") String param1, @Inject(bean="InjectedBean", property="someString") String param2, @Inject(bean="jboss.kernel:service=KernelController") Controller param3) {
        if (param1 == null) {
            throw new IllegalArgumentException("param1 == null");
        }
        if (param2 == null) {
            throw new IllegalArgumentException("param2 == null");
        }
        if (param3 == null) {
            throw new IllegalArgumentException("param3 == null");
        }
        this.installOk = true;
    }

    public boolean isInstallOk() {
        return this.installOk;
    }
}

