/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kernel.it;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.exoplatform.commons.Environment;
import org.exoplatform.container.RootContainer;
import org.exoplatform.kernel.demos.mc.ExternallyControlledInjectingBean;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.dependency.spi.Controller;
import org.junit.Assert;
import org.junit.Test;

public class ExternalMCInjectionTest {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.mc-int-tests.ExternalMCInjectionTest");
    protected String beanName = "ExternallyControlledInjectingBean";
    protected ExternallyControlledInjectingBean bean;
    protected boolean inJboss;
    protected boolean mcIntActive = true;

    protected void init() {
        LOG.info((Object)"init() method called");
        RootContainer rootContainer = RootContainer.getInstance();
        this.bean = (ExternallyControlledInjectingBean)rootContainer.getComponentInstance((Object)this.beanName);
        LOG.info((Object)("Retrieved " + this.beanName + ": " + this.bean));
        Assert.assertNotNull((String)(this.beanName + " not installed"), (Object)this.bean);
        this.inJboss = Environment.getInstance().getPlatform() == 3;
        LOG.info((Object)("Running inside JBoss? " + this.inJboss));
    }

    @Test
    public void test() {
        this.init();
        this.tests();
    }

    protected void tests() {
        this.testTransactionManager();
        this.testNameLookupMethodInjection();
        this.testMapInjection();
        this.testPropertyValueMethodInjection();
        this.testNestedPropertyInjection();
        this.testInstallMethod();
        this.testStarted();
    }

    protected void testTransactionManager() {
        TransactionManager tm = this.bean.getTransactionManager();
        if (this.inJboss && this.mcIntActive) {
            try {
                int status = tm.getStatus();
                LOG.info((Object)("Status before tx: " + tm.getStatus()));
                tm.begin();
                Assert.assertFalse((String)"TX status didn't change: ", (status == tm.getStatus() ? 1 : 0) != 0);
                LOG.info((Object)("Status in tx: " + tm.getStatus()));
                tm.commit();
                Assert.assertTrue((String)"TX status didn't return to original: ", (status == tm.getStatus() ? 1 : 0) != 0);
                LOG.info((Object)("Status after tx: " + tm.getStatus()));
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to use TransactionManager: ", ex);
            }
        } else {
            Assert.assertNull((String)"Injection should not have worked", (Object)tm);
        }
        LOG.info((Object)"testTransactionManager passed");
    }

    protected void testNameLookupMethodInjection() {
        boolean found;
        boolean bl = found = this.bean.getBean() != null;
        if (this.inJboss && this.mcIntActive) {
            Assert.assertTrue((String)"Method injection by name lookup not executed", (boolean)found);
        } else {
            Assert.assertFalse((String)"Method injection by name lookup should not have worked", (boolean)found);
        }
        LOG.info((Object)"testNameLookupMethodInjection passed");
    }

    protected void testMapInjection() {
        boolean found;
        Map bindings = this.bean.getBindingsMap();
        boolean bl = found = bindings != null;
        if (this.inJboss && this.mcIntActive) {
            Assert.assertTrue((String)"Map injection not executed", (boolean)found);
            Assert.assertEquals((String)"Bindings size", (long)bindings.size(), (long)1L);
            Assert.assertTrue((String)"Controller not bound", (boolean)(bindings.get(Controller.class) instanceof Controller));
        } else {
            Assert.assertFalse((String)"Map injection should not have worked", (boolean)found);
        }
        LOG.info((Object)"testMapInjection passed");
    }

    protected void testPropertyValueMethodInjection() {
        boolean found;
        String propertyValue = this.bean.getStringValue();
        boolean bl = found = propertyValue != null;
        if (this.inJboss && this.mcIntActive) {
            Assert.assertTrue((String)"Property value method injection not executed", (boolean)found);
            Assert.assertEquals((String)"Invalid injected value", (Object)propertyValue, (Object)"[This is some property value]");
        } else {
            Assert.assertFalse((String)"Property value method injection should not have worked", (boolean)found);
        }
        LOG.info((Object)"testPropertyValueMethodInjection passed");
    }

    protected void testNestedPropertyInjection() {
        boolean found;
        String propertyValue = this.bean.getConfig().getSomeProperty();
        boolean bl = found = propertyValue != null;
        if (this.inJboss && this.mcIntActive) {
            Assert.assertTrue((String)"Nested property value method injection not executed", (boolean)found);
            Assert.assertEquals((String)"Invalid injected value", (Object)propertyValue, (Object)"Test value");
        } else {
            Assert.assertFalse((String)"Nested property value method injection should not have worked", (boolean)found);
        }
        LOG.info((Object)"testNestedPropertyInjection passed");
    }

    protected void testInstallMethod() {
        boolean installOk = this.bean.isInstallOk();
        if (this.inJboss && this.mcIntActive) {
            Assert.assertTrue((String)"Install method not executed as expected", (boolean)installOk);
        } else {
            Assert.assertFalse((String)"Install method should not have worked", (boolean)installOk);
        }
        LOG.info((Object)"testInstallMethod passed");
    }

    protected void testStarted() {
        Assert.assertEquals((String)"start() method not called exactly once", (long)1L, (long)this.bean.getStartCount());
        LOG.info((Object)"testStarted passed");
    }
}

