/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.mc.impl;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.servlet.ServletContext;
import org.exoplatform.container.mc.MCIntegration;
import org.exoplatform.container.mc.impl.InterceptMC;
import org.exoplatform.container.mc.impl.MCComponentAdapter;
import org.exoplatform.container.mc.impl.MCIntConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelController;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.mc.common.ThreadLocalUtils;
import org.jboss.mc.servlet.vdf.api.VDFThreadLocalUtils;
import org.picocontainer.ComponentAdapter;

public class MCIntegrationImpl
implements MCIntegration {
    private static Log log = ExoLogger.getLogger(MCIntegrationImpl.class);
    private static MCIntegration mcint;
    private AbstractKernelController rootController;
    private MCIntConfig conf = new MCIntConfig();

    public static synchronized MCIntegration getInstance() {
        if (mcint == null) {
            mcint = new MCIntegrationImpl();
        }
        return mcint;
    }

    private MCIntegrationImpl() {
    }

    public synchronized AbstractKernelController getRootController() {
        if (this.rootController == null) {
            Kernel kernel = ThreadLocalUtils.getKernel();
            if (kernel != null) {
                this.rootController = (AbstractKernelController)kernel.getController();
            } else {
                log.warn((Object)"GateIn - MC integration not available");
                return null;
            }
        }
        return this.rootController;
    }

    public ComponentAdapter getMCAdapter(ComponentAdapter adapter) {
        InterceptMC interceptAnnotation = null;
        AbstractBeanMetaData data = this.conf.getByAdapter(adapter);
        if (data != null) {
            Set annotationMetaData = data.getAnnotations();
            if (annotationMetaData != null) {
                for (AnnotationMetaData annMeta : annotationMetaData) {
                    Annotation ann = annMeta.getAnnotationInstance();
                    if (ann.annotationType() != InterceptMC.class) continue;
                    interceptAnnotation = (InterceptMC)ann;
                }
            }
        } else {
            Class clazz = adapter.getComponentImplementation();
            interceptAnnotation = clazz.getAnnotation(InterceptMC.class);
        }
        if (interceptAnnotation == null) {
            return adapter;
        }
        AbstractKernelController controller = this.getRootController();
        if (controller != null) {
            adapter = new MCComponentAdapter((KernelController)controller, adapter, interceptAnnotation, data);
        }
        return adapter;
    }

    public boolean hasMCKernel(ComponentAdapter adapter) {
        return ThreadLocalUtils.getKernel() != null;
    }

    public void initThreadCtx(ServletContext ctx) {
        VDFThreadLocalUtils.init((ServletContext)ctx);
    }

    public void resetThreadCtx(ServletContext ctx) {
        VDFThreadLocalUtils.reset();
    }
}

