/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.mc.impl;

import org.exoplatform.container.mc.impl.InterceptMC;
import org.exoplatform.container.mc.impl.MCInjectionMode;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.plugins.helpers.StatelessController;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class MCComponentAdapter
implements ComponentAdapter {
    private KernelController controller;
    private ComponentAdapter delegate;
    private InterceptMC interceptMC;
    private Object lastComponentInstance;
    private AbstractBeanMetaData metaData;

    public MCComponentAdapter(KernelController controller, ComponentAdapter delegate, InterceptMC interceptMC, AbstractBeanMetaData data) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        if (controller instanceof StatelessController) {
            throw new IllegalArgumentException("controller is instanceof StatelessController");
        }
        this.controller = controller;
        this.delegate = delegate;
        this.interceptMC = interceptMC;
        this.metaData = data;
    }

    public Object getComponentKey() {
        return this.delegate.getComponentKey();
    }

    public Class getComponentImplementation() {
        return this.delegate.getComponentImplementation();
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
        Object target = this.lastComponentInstance;
        if (target != null) {
            return target;
        }
        String key = this.delegate.getComponentKey().toString();
        Object instance = this.delegate.getComponentInstance(container);
        try {
            if (this.metaData == null) {
                this.metaData = new AbstractBeanMetaData();
            }
            this.metaData.setName(key);
            this.metaData.setBean(instance.getClass().getName());
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((BeanMetaData)this.metaData);
            builder.setConstructorValue(instance);
            builder.ignoreCreate();
            builder.ignoreStart();
            builder.ignoreStop();
            builder.ignoreDestroy();
            builder.setAccessMode(this.getInjectionMode(this.interceptMC));
            AbstractKernelControllerContext ctx = new AbstractKernelControllerContext(null, builder.getBeanMetaData(), null);
            StatelessController ctrl = new StatelessController(this.controller);
            ctrl.install((ControllerContext)ctx);
            if (ctx.getError() != null) {
                throw ctx.getError();
            }
            if (ctrl.getStates().isBeforeState(ctx.getState(), ControllerState.INSTALLED)) {
                throw new IllegalArgumentException("Missing some dependency: " + ctx.getDependencyInfo().getUnresolvedDependencies(null));
            }
            this.lastComponentInstance = target = ctx.getTarget();
            return target;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to perform MC interception on component: " + this.delegate.getComponentImplementation(), ex);
        }
    }

    private BeanAccessMode getInjectionMode(InterceptMC interceptMC) {
        MCInjectionMode mode = interceptMC.injectionMode();
        switch (mode) {
            case ALL: {
                return BeanAccessMode.ALL;
            }
            case FIELDS: {
                return BeanAccessMode.FIELDS;
            }
        }
        return BeanAccessMode.STANDARD;
    }

    public void verify(PicoContainer container) throws PicoIntrospectionException {
        this.delegate.verify(container);
    }

    public void accept(PicoVisitor visitor) {
        this.delegate.accept(visitor);
    }
}

