/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.client.provider;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.widget.StyleHelper;
import org.guvnor.ala.ui.openshift.client.provider.OSEProviderConfigPresenter;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
@Templated
public class OSEProviderConfigView
implements IsElement,
OSEProviderConfigPresenter.View {
    @DataField(value="provider-type-name")
    private HTMLElement providerTypeName = Window.getDocument().createElement("strong");
    @Inject
    @DataField(value="provider-name-form")
    private Div providerNameForm;
    @Inject
    @DataField(value="provider-name")
    private TextInput providerName;
    @Inject
    @DataField(value="master-url-form")
    private Div masterURLForm;
    @Inject
    @DataField(value="master-url")
    private TextInput masterURL;
    @Inject
    @DataField(value="username-form")
    private Div usernameForm;
    @Inject
    @DataField(value="username")
    private TextInput username;
    @Inject
    @DataField(value="password-form")
    private Div passwordForm;
    @Inject
    @DataField(value="password")
    private TextInput password;
    private OSEProviderConfigPresenter presenter;

    public void init(OSEProviderConfigPresenter presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    private void init() {
        this.providerTypeName.setTextContent(this.getWizardTitle());
    }

    @Override
    public String getProviderName() {
        return this.providerName.getValue();
    }

    @Override
    public void setProviderName(String providerName) {
        this.providerName.setValue(providerName);
    }

    @Override
    public String getMasterURL() {
        return this.masterURL.getValue();
    }

    @Override
    public void setMasterURL(String masterURL) {
        this.masterURL.setValue(masterURL);
    }

    @Override
    public String getUsername() {
        return this.username.getValue();
    }

    @Override
    public void setUsername(String username) {
        this.username.setValue(username);
    }

    @Override
    public String getPassword() {
        return this.password.getValue();
    }

    @Override
    public void setPassword(String password) {
        this.password.setValue(password);
    }

    @Override
    public void disable() {
        this.resetFormState();
        this.enable(false);
    }

    @Override
    public void enable() {
        this.resetFormState();
        this.enable(true);
    }

    @Override
    public void setProviderNameStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.providerNameForm, (FormStatus)status);
    }

    @Override
    public void setMasterURLStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.masterURLForm, (FormStatus)status);
    }

    @Override
    public void setUsernameStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.usernameForm, (FormStatus)status);
    }

    @Override
    public void setPasswordStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.passwordForm, (FormStatus)status);
    }

    @Override
    public void clear() {
        this.resetFormState();
        this.providerName.setValue("");
        this.masterURL.setValue("");
        this.username.setValue("");
        this.password.setValue("");
    }

    @Override
    public String getWizardTitle() {
        return "OpenShift";
    }

    @EventHandler(value={"provider-name"})
    private void onProviderNameChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onProviderNameChange();
    }

    @EventHandler(value={"master-url"})
    private void onMasterURLChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onMasterURLChange();
    }

    @EventHandler(value={"username"})
    private void onUsernameChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onUserNameChange();
    }

    @EventHandler(value={"password"})
    private void onPasswordChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onPasswordChange();
    }

    private void resetFormState() {
        StyleHelper.setFormStatus((HTMLElement)this.providerNameForm, (FormStatus)FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.masterURLForm, (FormStatus)FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.usernameForm, (FormStatus)FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.passwordForm, (FormStatus)FormStatus.VALID);
    }

    private void enable(boolean enabled) {
        this.providerName.setDisabled(!enabled);
        this.masterURL.setDisabled(!enabled);
        this.username.setDisabled(!enabled);
        this.password.setDisabled(!enabled);
    }
}

