/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.client.pipeline.template;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.widget.StyleHelper;
import org.guvnor.ala.ui.openshift.client.pipeline.template.TemplateParamsFormPresenter;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
@Templated
public class TemplateParamsFormView
implements IsElement,
TemplateParamsFormPresenter.View {
    @Inject
    @DataField(value="runtime-form")
    private Div runtimeForm;
    @Inject
    @DataField(value="runtime-name")
    private TextInput runtimeName;
    @Inject
    @DataField(value="runtime-name-help-block")
    private Span runtimeNameHelp;
    @Inject
    @DataField(value="template-url-form")
    private Div templateURLForm;
    @Inject
    @DataField(value="template-url")
    private TextInput templateURL;
    @Inject
    @DataField(value="image-streams-url-form")
    private Div imageStreamsURLForm;
    @Inject
    @DataField(value="image-streams-url")
    private TextInput imageStreamsURL;
    @Inject
    @DataField(value="secrets-file-url-form")
    private Div secretsFileURLForm;
    @Inject
    @DataField(value="secrets-file-url")
    private TextInput secretsFileURL;
    @Inject
    @DataField(value="template-params-editor-container")
    private Div paramsEditorPresenterContainer;
    @Inject
    @DataField(value="required-params-help-form")
    private Div requitedParamsHelpForm;
    @Inject
    @DataField(value="required-params-help")
    private Span requiredParamsHelp;
    @Inject
    private TranslationService translationService;
    private TemplateParamsFormPresenter presenter;

    public void init(TemplateParamsFormPresenter presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    private void init() {
    }

    @Override
    public void setTemplateURL(String templateURL) {
        this.templateURL.setValue(templateURL);
    }

    @Override
    public String getTemplateURL() {
        return this.templateURL.getValue();
    }

    @Override
    public void setImageStreamsURL(String imageStreamsURL) {
        this.imageStreamsURL.setValue(imageStreamsURL);
    }

    @Override
    public String getImageStreamsURL() {
        return this.imageStreamsURL.getValue();
    }

    @Override
    public void setSecretsFileURL(String secretsFileURL) {
        this.secretsFileURL.setValue(secretsFileURL);
    }

    @Override
    public String getSecretsFileURL() {
        return this.secretsFileURL.getValue();
    }

    @Override
    public void setRuntimeName(String runtimeName) {
        this.runtimeName.setValue(runtimeName);
    }

    @Override
    public String getRuntimeName() {
        return this.runtimeName.getValue();
    }

    @Override
    public void setRuntimeNameStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.runtimeForm, (FormStatus)status);
    }

    @Override
    public void setTemplateURLStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.templateURLForm, (FormStatus)status);
    }

    @Override
    public void setImageStreamsURLStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.imageStreamsURLForm, (FormStatus)status);
    }

    @Override
    public void setSecretsFileURLStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.secretsFileURLForm, (FormStatus)status);
    }

    @Override
    public void setRequiredParamsHelpText(String requiredParamsHelpText) {
        this.requitedParamsHelpForm.getStyle().removeProperty("display");
        this.requiredParamsHelp.setInnerHTML(requiredParamsHelpText);
    }

    @Override
    public void clearRequiredParamsHelpText() {
        this.requitedParamsHelpForm.getStyle().setProperty("display", "none");
        this.requiredParamsHelp.setInnerHTML("");
    }

    @Override
    public void setRuntimeNameHelpText(String runtimeNameHelpText) {
        this.runtimeNameHelp.getStyle().removeProperty("display");
        this.runtimeNameHelp.setInnerHTML(runtimeNameHelpText);
    }

    @Override
    public void clearRuntimeNameHelpText() {
        this.runtimeNameHelp.getStyle().setProperty("display", "none");
        this.runtimeNameHelp.setInnerHTML("");
    }

    @Override
    public void clear() {
        this.setRuntimeName("");
        this.setTemplateURL("");
        this.setImageStreamsURL("");
        this.setSecretsFileURL("");
        this.clearRequiredParamsHelpText();
        this.clearRuntimeNameHelpText();
        this.resetFormState();
    }

    @Override
    public String getWizardTitle() {
        return this.translationService.getTranslation("TemplateParamsFormView.Title");
    }

    @Override
    public void setParamsEditorPresenter(org.jboss.errai.common.client.api.IsElement paramsEditorPresenter) {
        this.paramsEditorPresenterContainer.appendChild((Node)paramsEditorPresenter.getElement());
    }

    private void resetFormState() {
        this.setRuntimeNameStatus(FormStatus.VALID);
        this.setTemplateURLStatus(FormStatus.VALID);
        this.setImageStreamsURLStatus(FormStatus.VALID);
        this.setSecretsFileURLStatus(FormStatus.VALID);
    }

    @EventHandler(value={"runtime-name"})
    private void onRuntimeNameChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onRuntimeNameChange();
    }

    @EventHandler(value={"template-url"})
    private void onTemplateURLChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onTemplateURLChange();
    }

    @EventHandler(value={"image-streams-url"})
    private void onImageStreamsURLChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onImageStreamsURLChange();
    }

    @EventHandler(value={"secrets-file-url"})
    private void onSecretsFileURLChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onSecretsFileURLChange();
    }
}

