/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.handler;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Instance;
import org.guvnor.ala.ui.handler.AbstractProviderHandlerRegistry;
import org.guvnor.ala.ui.handler.ProviderHandler;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractProviderHandlerRegistryTest<T extends ProviderHandler> {
    protected static final int COUNT = 5;
    protected AbstractProviderHandlerRegistry<T> handlerRegistry;
    protected List<T> expectedHandlers;
    protected List<ProviderTypeKey> expectedKeys;
    @Mock
    protected Instance<T> handlerInstance;

    @Before
    public void setUp() {
        this.expectedKeys = this.createExpectedKeys();
        this.expectedHandlers = this.createExpectedHandlers();
        for (int i = 0; i < 5; ++i) {
            Mockito.when((Object)((ProviderHandler)this.expectedHandlers.get(i)).acceptProviderType(this.expectedKeys.get(i))).thenReturn((Object)true);
        }
        Mockito.when((Object)this.handlerInstance.iterator()).thenReturn(this.expectedHandlers.iterator());
        this.handlerRegistry = this.createHandlerRegistry(this.handlerInstance);
        ((Instance)Mockito.verify(this.handlerInstance, (VerificationMode)Mockito.times((int)1))).iterator();
    }

    @Test
    public void testProvidersEnabled() {
        this.expectedKeys.forEach(key -> Assert.assertTrue((boolean)this.handlerRegistry.isProviderEnabled(key)));
    }

    @Test
    public void testProviderNoEnabled() {
        ProviderTypeKey providerTypeKey = (ProviderTypeKey)Mockito.mock(ProviderTypeKey.class);
        Assert.assertFalse((boolean)this.handlerRegistry.isProviderEnabled(providerTypeKey));
    }

    @Test
    public void testGetProvidersHandler() {
        for (int i = 0; i < this.expectedKeys.size(); ++i) {
            ProviderTypeKey key = this.expectedKeys.get(i);
            Assert.assertNotNull((Object)this.handlerRegistry.isProviderEnabled(key));
            ProviderHandler handler = this.handlerRegistry.getProviderHandler(key);
            Assert.assertEquals(this.expectedHandlers.get(i), (Object)handler);
        }
    }

    @Test
    public void testGetProviderHandlerMissing() {
        ProviderTypeKey providerTypeKey = (ProviderTypeKey)Mockito.mock(ProviderTypeKey.class);
        Assert.assertNull((Object)this.handlerRegistry.getProviderHandler(providerTypeKey));
    }

    protected List<T> createExpectedHandlers() {
        ArrayList<T> handlers = new ArrayList<T>();
        for (int i = 0; i < 5; ++i) {
            T handler = this.mockHandler();
            Mockito.when((Object)handler.getPriority()).thenReturn((Object)1);
            handlers.add(handler);
        }
        return handlers;
    }

    protected List<ProviderTypeKey> createExpectedKeys() {
        ArrayList<ProviderTypeKey> keys = new ArrayList<ProviderTypeKey>();
        for (int i = 0; i < 5; ++i) {
            ProviderTypeKey key = (ProviderTypeKey)Mockito.mock(ProviderTypeKey.class);
            keys.add(key);
        }
        return keys;
    }

    protected abstract AbstractProviderHandlerRegistry<T> createHandlerRegistry(Instance<T> var1);

    protected abstract T mockHandler();
}

