/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.executor.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.guvnor.ala.build.maven.model.MavenBinary;
import org.guvnor.ala.util.VariableInterpolation;
import org.guvnor.ala.wildfly.config.WildflyRuntimeExecConfig;
import org.guvnor.ala.wildfly.config.impl.ContextAwareWildflyRuntimeExecConfig;
import org.guvnor.ala.wildfly.model.WildflyProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.file.Path;

public class ContextAwareWildflyRuntimeExecConfigTest {
    public static final String WAR_PATH_DEFAULT_EXPRESSION = "${input.war-path}";
    public static final String REDEPLOY_STRATEGY_DEFAULT_EXPRESSION = "${input.redeploy}";
    public static final String RUNTIME_NAME_DEFAULT_EXPRESSION = "${input.runtime-name}";
    public static final String FILE_PATH = "/path/to/file.war";
    public static final String REDEPLOY_OPTION = "none";
    public static final String RUNTIME_NAME = "runtimeNameValue";

    @Test
    public void testDefaultExpression() {
        Assert.assertEquals((Object)WAR_PATH_DEFAULT_EXPRESSION, (Object)new ContextAwareWildflyRuntimeExecConfig().getWarPath());
        Assert.assertEquals((Object)REDEPLOY_STRATEGY_DEFAULT_EXPRESSION, (Object)new ContextAwareWildflyRuntimeExecConfig().getRedeployStrategy());
        Assert.assertEquals((Object)RUNTIME_NAME_DEFAULT_EXPRESSION, (Object)new ContextAwareWildflyRuntimeExecConfig().getRuntimeName());
    }

    @Test
    public void testContextUsingMavenBinary() {
        ContextAwareWildflyRuntimeExecConfig config = new ContextAwareWildflyRuntimeExecConfig();
        HashMap<String, Object> context = new HashMap<String, Object>();
        WildflyProvider provider = (WildflyProvider)Mockito.mock(WildflyProvider.class);
        context.put("wildfly-provider", provider);
        MavenBinary binary = (MavenBinary)Mockito.mock(MavenBinary.class);
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)binary.getPath()).thenReturn((Object)path);
        Mockito.when((Object)path.toString()).thenReturn((Object)FILE_PATH);
        context.put("binary", binary);
        config.setContext(context);
        Assert.assertEquals((Object)provider, (Object)config.getProviderId());
        Assert.assertEquals((Object)FILE_PATH, (Object)config.getWarPath());
        WildflyRuntimeExecConfig configClone = config.asNewClone((WildflyRuntimeExecConfig)config);
        Assert.assertEquals((Object)provider, (Object)configClone.getProviderId());
        Assert.assertEquals((Object)FILE_PATH, (Object)configClone.getWarPath());
    }

    @Test
    public void testContextUsingPath() {
        ContextAwareWildflyRuntimeExecConfig config = new ContextAwareWildflyRuntimeExecConfig();
        WildflyProvider provider = (WildflyProvider)Mockito.mock(WildflyProvider.class);
        Map<String, WildflyProvider> context = Collections.singletonMap("wildfly-provider", provider);
        config.setContext(context);
        Assert.assertEquals((Object)provider, (Object)config.getProviderId());
        Assert.assertEquals((Object)WAR_PATH_DEFAULT_EXPRESSION, (Object)config.getWarPath());
        WildflyRuntimeExecConfig configClone = config.asNewClone((WildflyRuntimeExecConfig)config);
        Assert.assertEquals((Object)provider, (Object)configClone.getProviderId());
        Assert.assertEquals((Object)WAR_PATH_DEFAULT_EXPRESSION, (Object)configClone.getWarPath());
    }

    @Test
    public void testVariablesResolution() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("war-path", FILE_PATH);
        values.put("redeploy", REDEPLOY_OPTION);
        values.put("runtime-name", RUNTIME_NAME);
        ContextAwareWildflyRuntimeExecConfig config = new ContextAwareWildflyRuntimeExecConfig();
        ContextAwareWildflyRuntimeExecConfig varConfig = (ContextAwareWildflyRuntimeExecConfig)VariableInterpolation.interpolate(Collections.singletonMap("input", values), (Object)config);
        Assert.assertEquals((Object)FILE_PATH, (Object)varConfig.getWarPath());
        Assert.assertEquals((Object)REDEPLOY_OPTION, (Object)varConfig.getRedeployStrategy());
        Assert.assertEquals((Object)RUNTIME_NAME, (Object)varConfig.getRuntimeName());
    }
}

