/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.asset.management.backend.service.ManagedStatusUpdater;
import org.guvnor.asset.management.backend.service.RepositoryStructureModelLoader;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectRepositoryResolver;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.validation.ValidationUtils;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class RepositoryStructureServiceImpl
implements RepositoryStructureService {
    private IOService ioService;
    private POMService pomService;
    private ProjectService<? extends Project> projectService;
    private GuvnorM2Repository m2service;
    private CommentedOptionFactory optionsFactory;
    private ProjectRepositoryResolver repositoryResolver;
    private RepositoryStructureModelLoader modelLoader;
    private ManagedStatusUpdater managedStatusUpdater;

    public RepositoryStructureServiceImpl() {
    }

    @Inject
    public RepositoryStructureServiceImpl(@Named(value="ioStrategy") IOService ioService, POMService pomService, ProjectService<? extends Project> projectService, GuvnorM2Repository m2service, CommentedOptionFactory optionsFactory, ProjectRepositoryResolver repositoryResolver, RepositoryStructureModelLoader modelLoader, ManagedStatusUpdater managedStatusUpdater) {
        this.ioService = ioService;
        this.pomService = pomService;
        this.projectService = projectService;
        this.m2service = m2service;
        this.optionsFactory = optionsFactory;
        this.repositoryResolver = repositoryResolver;
        this.modelLoader = modelLoader;
        this.managedStatusUpdater = managedStatusUpdater;
    }

    public org.uberfire.backend.vfs.Path initRepositoryStructure(GAV gav, Repository repo, DeploymentMode mode) {
        POM pom = new POM(repo.getAlias(), repo.getAlias(), gav, true);
        if (DeploymentMode.VALIDATED.equals((Object)mode)) {
            this.checkRepositories(pom);
        }
        org.uberfire.backend.vfs.Path fsRoot = repo.getRoot();
        org.uberfire.backend.vfs.Path pathToPom = this.pomService.create(fsRoot, "", pom);
        this.m2service.deployParentPom(gav);
        this.managedStatusUpdater.updateManagedStatus(repo, true);
        return pathToPom;
    }

    public org.uberfire.backend.vfs.Path initRepositoryStructure(POM pom, String baseUrl, Repository repository, boolean multiProject, DeploymentMode mode) {
        if (pom == null || baseUrl == null || repository == null) {
            return null;
        }
        if (DeploymentMode.VALIDATED.equals((Object)mode)) {
            this.checkRepositories(pom);
        }
        if (multiProject) {
            pom.setPackaging("pom");
            org.uberfire.backend.vfs.Path fsRoot = repository.getRoot();
            org.uberfire.backend.vfs.Path pathToPom = this.pomService.create(fsRoot, baseUrl, pom);
            this.m2service.deployParentPom(pom.getGav());
            this.managedStatusUpdater.updateManagedStatus(repository, true);
            return pathToPom;
        }
        Project project = (Project)this.projectService.newProject(repository.getBranchRoot(repository.getDefaultBranch()), pom, baseUrl, mode);
        return project.getPomXMLPath();
    }

    private void checkRepositories(POM pom) {
        Set repositories = this.repositoryResolver.getRepositoriesResolvingArtifact(pom.getGav(), new MavenRepositoryMetadata[0]);
        if (repositories.size() > 0) {
            throw new GAVAlreadyExistsException(pom.getGav(), repositories);
        }
    }

    public Repository updateManagedStatus(Repository repo, boolean managed) {
        return this.managedStatusUpdater.updateManagedStatus(repo, managed);
    }

    public org.uberfire.backend.vfs.Path convertToMultiProjectStructure(List<Project> projects, GAV parentGav, Repository repo, boolean updateChildrenGav, String comment) {
        if (projects == null || parentGav == null || repo == null) {
            return null;
        }
        try {
            org.uberfire.backend.vfs.Path path = this.initRepositoryStructure(parentGav, repo, DeploymentMode.FORCED);
            POM parentPom = (POM)this.pomService.load(path);
            if (parentPom == null) {
                org.uberfire.backend.vfs.Path path2 = null;
                return path2;
            }
            this.ioService.startBatch(new FileSystem[]{Paths.convert((org.uberfire.backend.vfs.Path)path).getFileSystem()}, new Option[]{this.optionsFactory.makeCommentedOption(comment != null ? comment : "")});
            boolean saveParentPom = false;
            for (Project project : projects) {
                POM pom = (POM)this.pomService.load(project.getPomXMLPath());
                pom.setParent(parentGav);
                if (updateChildrenGav) {
                    pom.getGav().setGroupId(parentGav.getGroupId());
                    pom.getGav().setVersion(parentGav.getVersion());
                }
                this.pomService.save(project.getPomXMLPath(), (Object)pom, null, comment);
                parentPom.setPackaging("pom");
                parentPom.getModules().add(pom.getName() != null ? pom.getName() : pom.getGav().getArtifactId());
                saveParentPom = true;
            }
            if (saveParentPom) {
                this.pomService.save(path, (Object)parentPom, null, comment);
            }
            org.uberfire.backend.vfs.Path path3 = path;
            return path3;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public RepositoryStructureModel load(Repository repository, String branch) {
        return this.modelLoader.load(repository, branch, true);
    }

    public RepositoryStructureModel load(Repository repository, String branch, boolean includeModules) {
        return this.modelLoader.load(repository, branch, includeModules);
    }

    public void save(org.uberfire.backend.vfs.Path pathToPomXML, RepositoryStructureModel model, String comment) {
        FileSystem fs = Paths.convert((org.uberfire.backend.vfs.Path)pathToPomXML).getFileSystem();
        try {
            this.pomService.save(pathToPomXML, model.getPOM(), model.getPOMMetaData(), comment, true);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public boolean isValidProjectName(String name) {
        return ValidationUtils.isFileName((String)name);
    }

    public boolean isValidGroupId(String groupId) {
        String[] groupIdComponents;
        if (groupId == null || "".equals(groupId.trim())) {
            return false;
        }
        for (String s : groupIdComponents = groupId.split("\\.", -1)) {
            if (ValidationUtils.isArtifactIdentifier((String)s)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidArtifactId(String artifactId) {
        String[] artifactIdComponents;
        if (artifactId == null || "".equals(artifactId.trim())) {
            return false;
        }
        for (String s : artifactIdComponents = artifactId.split("\\.", -1)) {
            if (ValidationUtils.isArtifactIdentifier((String)s)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidVersion(String version) {
        if (version == null || "".equals(version.trim())) {
            return false;
        }
        return version.matches("^[a-zA-Z0-9\\.\\-_]+$");
    }

    public void delete(org.uberfire.backend.vfs.Path pathToPomXML, String comment) {
        this.projectService.delete(pathToPomXML, comment);
    }

    private List<Project> getProjects(org.uberfire.backend.vfs.Path branchRoot) {
        ArrayList<Project> repositoryProjects = new ArrayList<Project>();
        if (branchRoot == null) {
            return repositoryProjects;
        }
        DirectoryStream nioRepositoryPaths = this.ioService.newDirectoryStream(Paths.convert((org.uberfire.backend.vfs.Path)branchRoot));
        for (Path nioRepositoryPath : nioRepositoryPaths) {
            org.uberfire.backend.vfs.Path projectPath;
            Project project;
            if (!Files.isDirectory((Path)nioRepositoryPath, (LinkOption[])new LinkOption[0]) || (project = this.projectService.resolveProject(projectPath = Paths.convert((Path)nioRepositoryPath))) == null) continue;
            repositoryProjects.add(project);
        }
        return repositoryProjects;
    }
}

