/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.backend.server.ProjectConfigurationContentHandler;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.project.service.KModuleService;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.workingset.client.model.WorkingSetSettings;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.commons.validation.PortablePreconditions;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationFactory;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.security.Identity;

@Service
@ApplicationScoped
public class ProjectServiceImpl
implements ProjectService {
    private static final String SOURCE_FILENAME = "src";
    private static final String POM_PATH = "pom.xml";
    private static final String PROJECT_IMPORTS_PATH = "project.imports";
    private static final String KMODULE_PATH = "src/main/resources/META-INF/kmodule.xml";
    private static final String MAIN_SRC_PATH = "src/main/java";
    private static final String TEST_SRC_PATH = "src/test/java";
    private static final String MAIN_RESOURCES_PATH = "src/main/resources";
    private static final String TEST_RESOURCES_PATH = "src/test/resources";
    private IOService ioService;
    private Paths paths;
    private POMService pomService;
    private KModuleService kModuleService;
    private MetadataService metadataService;
    private ProjectConfigurationContentHandler projectConfigurationContentHandler;
    private ConfigurationService configurationService;
    private ConfigurationFactory configurationFactory;
    private Event<NewProjectEvent> newProjectEvent;
    private Event<NewPackageEvent> newPackageEvent;
    private Identity identity;

    public ProjectServiceImpl() {
    }

    @Inject
    public ProjectServiceImpl(@Named(value="ioStrategy") IOService ioService, Paths paths, POMService pomService, KModuleService kModuleService, MetadataService metadataService, ProjectConfigurationContentHandler projectConfigurationContentHandler, ConfigurationService configurationService, ConfigurationFactory configurationFactory, Event<NewProjectEvent> newProjectEvent, Event<NewPackageEvent> newPackageEvent, Identity identity) {
        this.ioService = ioService;
        this.paths = paths;
        this.pomService = pomService;
        this.kModuleService = kModuleService;
        this.metadataService = metadataService;
        this.projectConfigurationContentHandler = projectConfigurationContentHandler;
        this.configurationService = configurationService;
        this.configurationFactory = configurationFactory;
        this.newProjectEvent = newProjectEvent;
        this.newPackageEvent = newPackageEvent;
        this.identity = identity;
    }

    public WorkingSetSettings loadWorkingSetConfig(org.uberfire.backend.vfs.Path project) {
        return new WorkingSetSettings();
    }

    public Project resolveProject(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = this.paths.convert(resource).normalize();
            if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
                path = path.getParent();
            }
            if (this.hasPom(path) && this.hasKModule(path)) {
                return this.makeProject(path);
            }
            while (path.getNameCount() > 0 && !path.getFileName().toString().equals(SOURCE_FILENAME)) {
                path = path.getParent();
            }
            if (path.getNameCount() == 0) {
                return null;
            }
            if ((path = path.getParent()).getNameCount() == 0 || path == null) {
                return null;
            }
            if (!this.hasPom(path)) {
                return null;
            }
            if (!this.hasKModule(path)) {
                return null;
            }
            return this.makeProject(path);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private Project makeProject(Path nioProjectRootPath) {
        ConfigItem roles;
        org.uberfire.backend.vfs.Path projectRootPath = this.paths.convert(nioProjectRootPath);
        String projectName = projectRootPath.getFileName();
        org.uberfire.backend.vfs.Path pomXMLPath = this.paths.convert(nioProjectRootPath.resolve(POM_PATH), false);
        org.uberfire.backend.vfs.Path kmoduleXMLPath = this.paths.convert(nioProjectRootPath.resolve(KMODULE_PATH), false);
        org.uberfire.backend.vfs.Path importsXMLPath = this.paths.convert(nioProjectRootPath.resolve(PROJECT_IMPORTS_PATH), false);
        Project project = new Project(projectRootPath, pomXMLPath, kmoduleXMLPath, importsXMLPath, projectName);
        ConfigGroup projectConfiguration = this.findProjectConfig(projectRootPath);
        if (projectConfiguration != null && (roles = projectConfiguration.getConfigItem("security:roles")) != null) {
            for (String role : (List)roles.getValue()) {
                project.getRoles().add(role);
            }
        }
        return project;
    }

    public Package resolvePackage(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Project project = this.resolveProject(resource);
            if (project == null) {
                return null;
            }
            if (this.isPom(resource) || this.isKModule(resource)) {
                return null;
            }
            return this.makePackage(project, resource);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private Package makePackage(Project project, org.uberfire.backend.vfs.Path resource) {
        org.uberfire.backend.vfs.Path projectRoot = project.getRootPath();
        Path nioProjectRoot = this.paths.convert(projectRoot);
        Path nioMainSrcPath = nioProjectRoot.resolve(MAIN_SRC_PATH);
        Path nioTestSrcPath = nioProjectRoot.resolve(TEST_SRC_PATH);
        Path nioMainResourcesPath = nioProjectRoot.resolve(MAIN_RESOURCES_PATH);
        Path nioTestResourcesPath = nioProjectRoot.resolve(TEST_RESOURCES_PATH);
        Path nioResource = this.paths.convert(resource);
        if (Files.isRegularFile((Path)nioResource, (LinkOption[])new LinkOption[0])) {
            nioResource = nioResource.getParent();
        }
        String packageName = null;
        Path packagePath = null;
        if (nioResource.startsWith(nioMainSrcPath)) {
            packagePath = nioMainSrcPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioTestSrcPath)) {
            packagePath = nioTestSrcPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioMainResourcesPath)) {
            packagePath = nioMainResourcesPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioTestResourcesPath)) {
            packagePath = nioTestResourcesPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        }
        if (packageName == null) {
            return null;
        }
        boolean includeAttributes = Files.exists((Path)nioMainSrcPath.resolve(packagePath), (LinkOption[])new LinkOption[0]);
        org.uberfire.backend.vfs.Path mainSrcPath = this.paths.convert(nioMainSrcPath.resolve(packagePath), includeAttributes);
        includeAttributes = Files.exists((Path)nioTestSrcPath.resolve(packagePath), (LinkOption[])new LinkOption[0]);
        org.uberfire.backend.vfs.Path testSrcPath = this.paths.convert(nioTestSrcPath.resolve(packagePath), includeAttributes);
        includeAttributes = Files.exists((Path)nioMainResourcesPath.resolve(packagePath), (LinkOption[])new LinkOption[0]);
        org.uberfire.backend.vfs.Path mainResourcesPath = this.paths.convert(nioMainResourcesPath.resolve(packagePath), includeAttributes);
        includeAttributes = Files.exists((Path)nioTestResourcesPath.resolve(packagePath), (LinkOption[])new LinkOption[0]);
        org.uberfire.backend.vfs.Path testResourcesPath = this.paths.convert(nioTestResourcesPath.resolve(packagePath), includeAttributes);
        Package pkg = new Package(project.getRootPath(), mainSrcPath, testSrcPath, mainResourcesPath, testResourcesPath, packageName, this.getPackageDisplayName(packageName));
        return pkg;
    }

    private String getPackageDisplayName(String packageName) {
        return packageName.isEmpty() ? "<default>" : packageName;
    }

    public boolean isPom(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return false;
            }
            Project project = this.resolveProject(resource);
            Path path = this.paths.convert(resource).normalize();
            Path pomFilePath = this.paths.convert(project.getPomXMLPath());
            return path.startsWith(pomFilePath);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public boolean isKModule(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return false;
            }
            Project project = this.resolveProject(resource);
            Path path = this.paths.convert(resource).normalize();
            Path kmoduleFilePath = this.paths.convert(project.getKModuleXMLPath());
            return path.startsWith(kmoduleFilePath);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Project newProject(Repository repository, String projectName, POM pom, String baseUrl) {
        try {
            org.uberfire.backend.vfs.Path fsRoot = repository.getRoot();
            org.uberfire.backend.vfs.Path projectRootPath = this.paths.convert(this.paths.convert(fsRoot).resolve(projectName), false);
            this.kModuleService.setUpKModuleStructure(projectRootPath);
            this.pomService.create(projectRootPath, baseUrl, pom);
            org.uberfire.backend.vfs.Path projectConfigPath = this.paths.convert(this.paths.convert(projectRootPath).resolve(PROJECT_IMPORTS_PATH), false);
            this.ioService.createFile(this.paths.convert(projectConfigPath), new FileAttribute[0]);
            this.ioService.write(this.paths.convert(projectConfigPath), this.projectConfigurationContentHandler.toString(new ProjectImports()), new OpenOption[0]);
            Project project = this.resolveProject(projectRootPath);
            this.newProjectEvent.fire((Object)new NewProjectEvent(project));
            String defaultWorkspacePath = pom.getGav().getGroupId() + "/" + pom.getGav().getArtifactId();
            org.uberfire.backend.vfs.Path defaultPackagePath = this.paths.convert(this.paths.convert(projectRootPath).resolve(MAIN_RESOURCES_PATH), false);
            Package defaultPackage = this.resolvePackage(defaultPackagePath);
            Package defaultWorkspacePackage = this.doNewPackage(defaultPackage, defaultWorkspacePath);
            this.newPackageEvent.fire((Object)new NewPackageEvent(defaultWorkspacePackage));
            return project;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Package newPackage(Package parentPackage, String packageName) {
        try {
            Package newPackage = this.doNewPackage(parentPackage, packageName);
            this.newPackageEvent.fire((Object)new NewPackageEvent(newPackage));
            return newPackage;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private Package doNewPackage(Package parentPackage, String packageName) {
        Path nioTestResourcesPackagePath;
        Path nioMainResourcesPackagePath;
        Path nioTestSrcPackagePath;
        String newPackageName = packageName;
        if (newPackageName.contains(".")) {
            newPackageName = newPackageName.replace(".", "/");
        }
        org.uberfire.backend.vfs.Path mainSrcPath = parentPackage.getPackageMainSrcPath();
        org.uberfire.backend.vfs.Path testSrcPath = parentPackage.getPackageTestSrcPath();
        org.uberfire.backend.vfs.Path mainResourcesPath = parentPackage.getPackageMainResourcesPath();
        org.uberfire.backend.vfs.Path testResourcesPath = parentPackage.getPackageTestResourcesPath();
        org.uberfire.backend.vfs.Path pkgPath = null;
        Path nioMainSrcPackagePath = this.paths.convert(mainSrcPath).resolve(newPackageName);
        if (!Files.exists((Path)nioMainSrcPackagePath, (LinkOption[])new LinkOption[0])) {
            pkgPath = this.paths.convert(this.ioService.createDirectory(nioMainSrcPackagePath, new FileAttribute[0]));
        }
        if (!Files.exists((Path)(nioTestSrcPackagePath = this.paths.convert(testSrcPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
            pkgPath = this.paths.convert(this.ioService.createDirectory(nioTestSrcPackagePath, new FileAttribute[0]));
        }
        if (!Files.exists((Path)(nioMainResourcesPackagePath = this.paths.convert(mainResourcesPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
            pkgPath = this.paths.convert(this.ioService.createDirectory(nioMainResourcesPackagePath, new FileAttribute[0]));
        }
        if (!Files.exists((Path)(nioTestResourcesPackagePath = this.paths.convert(testResourcesPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
            pkgPath = this.paths.convert(this.ioService.createDirectory(nioTestResourcesPackagePath, new FileAttribute[0]));
        }
        PortablePreconditions.checkNotNull((String)"pkgPath", (Object)pkgPath);
        Package newPackage = this.resolvePackage(pkgPath);
        return newPackage;
    }

    private boolean hasPom(Path path) {
        Path pomPath = path.resolve(POM_PATH);
        return Files.exists((Path)pomPath, (LinkOption[])new LinkOption[0]);
    }

    private boolean hasKModule(Path path) {
        Path kmodulePath = path.resolve(KMODULE_PATH);
        return Files.exists((Path)kmodulePath, (LinkOption[])new LinkOption[0]);
    }

    public ProjectImports load(org.uberfire.backend.vfs.Path path) {
        String content = this.ioService.readAllString(this.paths.convert(path));
        return this.projectConfigurationContentHandler.toModel(content);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, ProjectImports projectImports, Metadata metadata, String comment) {
        try {
            this.ioService.write(this.paths.convert(resource), this.projectConfigurationContentHandler.toString(projectImports), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(name, null, commitMessage, when);
        return co;
    }

    public void addRole(Project project, String role) {
        ConfigGroup thisProjectConfig = this.findProjectConfig(project.getRootPath());
        if (thisProjectConfig == null) {
            thisProjectConfig = this.configurationFactory.newConfigGroup(ConfigType.PROJECT, project.getRootPath().toURI(), "Project '" + project.getProjectName() + "' configuration");
            thisProjectConfig.addConfigItem(this.configurationFactory.newConfigItem("security:roles", new ArrayList()));
            this.configurationService.addConfiguration(thisProjectConfig);
        }
        if (thisProjectConfig == null) {
            throw new IllegalArgumentException("Project " + project.getProjectName() + " not found");
        }
        ConfigItem roles = thisProjectConfig.getConfigItem("security:roles");
        ((List)roles.getValue()).add(role);
        this.configurationService.updateConfiguration(thisProjectConfig);
    }

    public void removeRole(Project project, String role) {
        ConfigGroup thisProjectConfig = this.findProjectConfig(project.getRootPath());
        if (thisProjectConfig == null) {
            throw new IllegalArgumentException("Project " + project.getProjectName() + " not found");
        }
        ConfigItem roles = thisProjectConfig.getConfigItem("security:roles");
        ((List)roles.getValue()).remove(role);
        this.configurationService.updateConfiguration(thisProjectConfig);
    }

    protected ConfigGroup findProjectConfig(org.uberfire.backend.vfs.Path projectRoot) {
        List groups = this.configurationService.getConfiguration(ConfigType.PROJECT);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(projectRoot.toURI())) continue;
                return groupConfig;
            }
        }
        return null;
    }
}

