/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.inject.Instance;
import org.guvnor.common.services.project.backend.server.ProjectSearchServiceImpl;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProjectSearchServiceTest {
    @Mock
    RepositoryService repositoryService;
    @Mock
    Instance<ProjectService<? extends Project>> projectServices;
    @Mock
    ProjectService projectService;
    @Mock
    Project itemA;
    @Mock
    Project itemB;
    private ProjectSearchServiceImpl searchService;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.itemA.getIdentifier()).thenReturn((Object)"itemA");
        Mockito.when((Object)this.itemB.getIdentifier()).thenReturn((Object)"itemB");
        Mockito.when((Object)this.itemA.getProjectName()).thenReturn((Object)"Item A");
        Mockito.when((Object)this.itemB.getProjectName()).thenReturn((Object)"Item B");
        Mockito.when((Object)this.repositoryService.getAllRepositories()).thenReturn(Arrays.asList((Repository)Mockito.mock(Repository.class)));
        Mockito.when((Object)this.projectServices.get()).thenReturn((Object)this.projectService);
        Mockito.when((Object)this.projectService.getAllProjects((Repository)Mockito.any(), Mockito.anyString())).thenReturn((Object)new HashSet(){
            {
                this.add(ProjectSearchServiceTest.this.itemA);
                this.add(ProjectSearchServiceTest.this.itemB);
            }
        });
        this.searchService = new ProjectSearchServiceImpl(this.repositoryService, this.projectServices);
    }

    @Test
    public void testSearchById() throws Exception {
        Collection result = this.searchService.searchById(Arrays.asList("itemA"));
        Assert.assertEquals((long)result.size(), (long)1L);
        Assert.assertEquals((Object)((Project)result.iterator().next()).getProjectName(), (Object)"Item A");
    }

    @Test
    public void testSearchByAlias() throws Exception {
        Collection result = this.searchService.searchByName("Item", 10, true);
        Assert.assertEquals((long)result.size(), (long)2L);
    }

    @Test
    public void testSearchCaseSensitiveEmpty() throws Exception {
        Collection result = this.searchService.searchByName("item", 10, true);
        Assert.assertEquals((long)result.size(), (long)0L);
    }

    @Test
    public void testSearchCaseUnsensitive() throws Exception {
        Collection result = this.searchService.searchByName("item", 10, false);
        Assert.assertEquals((long)result.size(), (long)2L);
    }

    @Test
    public void testSearchMaxItems() throws Exception {
        Collection result = this.searchService.searchByName("item", 1, false);
        Assert.assertEquals((long)result.size(), (long)1L);
    }
}

