/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.guvnor.structure.client.editors.context.GuvnorStructureContext;
import org.guvnor.structure.client.editors.repository.list.RepositoryItemPresenter;
import org.guvnor.structure.client.editors.repository.list.RepositoryItemView;
import org.guvnor.structure.client.security.RepositoryController;
import org.guvnor.structure.repositories.PublicURI;
import org.guvnor.structure.repositories.Repository;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class RepositoryItemPresenterTest {
    @Mock
    private GuvnorStructureContext guvnorStructureContext;
    @Mock
    private RepositoryController repositoryController;
    @Mock
    private RepositoryItemView view;
    private RepositoryItemPresenter presenter;
    @Mock
    private Repository repository;
    List<PublicURI> publicURIs = new ArrayList<PublicURI>();
    List<String> branches = new ArrayList<String>();
    @Mock
    PublicURI uri1;
    @Mock
    PublicURI uri2;

    @Before
    public void init() {
        this.branches.add("master");
        Mockito.when((Object)this.uri1.getProtocol()).thenReturn((Object)"test-protocol1");
        Mockito.when((Object)this.uri1.getURI()).thenReturn((Object)"uri1");
        Mockito.when((Object)this.uri2.getProtocol()).thenReturn((Object)"test-protocol2");
        Mockito.when((Object)this.uri2.getURI()).thenReturn((Object)"uri2");
        this.presenter = new RepositoryItemPresenter(this.view, this.guvnorStructureContext, this.repositoryController);
        Mockito.when((Object)this.repository.getAlias()).thenReturn((Object)"TestRepo");
        Mockito.when((Object)this.repositoryController.canUpdateRepository(this.repository)).thenReturn((Object)false);
        Mockito.when((Object)this.repositoryController.canDeleteRepository(this.repository)).thenReturn((Object)false);
    }

    @Test
    public void repositoryWithPublicUrisAndBranchesLoadTest() {
        this.publicURIs.add(this.uri1);
        this.publicURIs.add(this.uri2);
        this.branches.add("development");
        this.branches.add("release");
        this.repositoryLoadTest(this.publicURIs, this.branches);
    }

    @Test
    public void repositoryWithPublicUrisAndNoBranchesLoadTest() {
        this.publicURIs.add(this.uri1);
        this.publicURIs.add(this.uri2);
        this.repositoryLoadTest(this.publicURIs, this.branches);
    }

    @Test
    public void repositoryWithNoPublicUrisAndBranchesLoadTest() {
        this.branches.add("development");
        this.branches.add("release");
        this.repositoryLoadTest(this.publicURIs, this.branches);
    }

    @Test
    public void repositoryWithNoPublicUrisAndNoBranchesLoadTest() {
        this.repositoryLoadTest(this.publicURIs, this.branches);
    }

    private void repositoryLoadTest(List<PublicURI> uris, List<String> branches) {
        Mockito.when((Object)this.repository.getAlias()).thenReturn((Object)"TestRepo");
        Mockito.when((Object)this.repository.getPublicURIs()).thenReturn(this.publicURIs);
        Mockito.when((Object)this.repository.getBranches()).thenReturn(branches);
        this.presenter.setRepository(this.repository, "master");
        ((RepositoryItemView)Mockito.verify((Object)this.view)).setPresenter(this.presenter);
        ((RepositoryItemView)Mockito.verify((Object)this.view)).setRepositoryName("TestRepo");
        ((RepositoryItemView)Mockito.verify((Object)this.view)).setUpdateEnabled(false);
        ((RepositoryItemView)Mockito.verify((Object)this.view)).setDeleteEnabled(false);
        if (uris.size() > 0) {
            ((RepositoryItemView)Mockito.verify((Object)this.view)).showAvailableProtocols();
            ((RepositoryItemView)Mockito.verify((Object)this.view)).setDaemonURI(uris.get(0).getURI());
            for (PublicURI publicURI : uris) {
                ((RepositoryItemView)Mockito.verify((Object)this.view)).addProtocol(publicURI.getProtocol());
            }
        }
        ((RepositoryItemView)Mockito.verify((Object)this.view)).setUriId("view-uri-for-TestRepo");
        ((RepositoryItemView)Mockito.verify((Object)this.view)).clearBranches();
        Collections.reverse(branches);
        for (String branch : branches) {
            ((RepositoryItemView)Mockito.verify((Object)this.view)).addBranch(branch);
        }
        ((RepositoryItemView)Mockito.verify((Object)this.view)).setSelectedBranch("master");
        ((RepositoryItemView)Mockito.verify((Object)this.view)).refresh();
    }

    @Test
    public void refreshBranchesTest() {
        this.branches.add("development");
        this.branches.add("release");
        Mockito.when((Object)this.view.getSelectedBranch()).thenReturn((Object)"development");
        this.repositoryLoadTest(this.publicURIs, this.branches);
        this.branches.add("NewBranch");
        this.presenter.refreshBranches();
        ((RepositoryItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearBranches();
        ((RepositoryItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addBranch("master");
        ((RepositoryItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addBranch("development");
        ((RepositoryItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addBranch("release");
        ((RepositoryItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addBranch("NewBranch");
        ((RepositoryItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSelectedBranch("development");
    }
}

