/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories;

import java.util.Collection;
import java.util.List;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryInfo;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.java.nio.base.version.VersionRecord;

public class RepositoryServiceCallerMock
implements Caller<RepositoryService> {
    protected RepositoryServiceWrapper repositoryServiceWrapper;
    protected RemoteCallback remoteCallback;

    public RepositoryServiceCallerMock(RepositoryService repositoryService) {
        this.repositoryServiceWrapper = new RepositoryServiceWrapper(repositoryService);
    }

    public RepositoryService call() {
        return this.repositoryServiceWrapper;
    }

    public RepositoryService call(RemoteCallback<?> remoteCallback) {
        return this.call(remoteCallback, (ErrorCallback<?>)null);
    }

    public RepositoryService call(RemoteCallback<?> remoteCallback, ErrorCallback<?> errorCallback) {
        this.remoteCallback = remoteCallback;
        return this.repositoryServiceWrapper;
    }

    private class RepositoryServiceWrapper
    implements RepositoryService {
        RepositoryService repositoryService;

        public RepositoryServiceWrapper(RepositoryService repositoryService) {
            this.repositoryService = repositoryService;
        }

        public RepositoryInfo getRepositoryInfo(String alias) {
            RepositoryInfo result = this.repositoryService.getRepositoryInfo(alias);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public List<VersionRecord> getRepositoryHistory(String alias, int startIndex) {
            List result = this.repositoryService.getRepositoryHistory(alias, startIndex);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public List<VersionRecord> getRepositoryHistory(String alias, int startIndex, int endIndex) {
            List result = this.repositoryService.getRepositoryHistory(alias, startIndex, endIndex);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public List<VersionRecord> getRepositoryHistoryAll(String alias) {
            List result = this.repositoryService.getRepositoryHistoryAll(alias);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Repository getRepository(String alias) {
            Repository result = this.repositoryService.getRepository(alias);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Repository getRepository(Path root) {
            Repository result = this.repositoryService.getRepository(root);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Collection<Repository> getAllRepositories() {
            Collection result = this.repositoryService.getAllRepositories();
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Collection<Repository> getRepositories() {
            Collection result = this.repositoryService.getRepositories();
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Repository createRepository(OrganizationalUnit organizationalUnit, String scheme, String alias, RepositoryEnvironmentConfigurations configuration) throws RepositoryAlreadyExistsException {
            Repository result = this.repositoryService.createRepository(organizationalUnit, scheme, alias, configuration);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Repository createRepository(String scheme, String alias, RepositoryEnvironmentConfigurations configuration) throws RepositoryAlreadyExistsException {
            Repository result = this.repositoryService.createRepository(scheme, alias, configuration);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public String normalizeRepositoryName(String name) {
            String result = this.repositoryService.normalizeRepositoryName(name);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public boolean validateRepositoryName(String name) {
            boolean result = this.repositoryService.validateRepositoryName(name);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public void addGroup(Repository repository, String group) {
            this.repositoryService.addGroup(repository, group);
        }

        public void removeGroup(Repository repository, String group) {
            this.repositoryService.removeGroup(repository, group);
        }

        public void removeRepository(String alias) {
            this.repositoryService.removeRepository(alias);
        }

        public Repository updateRepositoryConfiguration(Repository repository, RepositoryEnvironmentConfigurations config) {
            Repository result = this.repositoryService.updateRepositoryConfiguration(repository, config);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }
    }
}

