/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.guvnor.structure.client.editors.TestUtil;
import org.guvnor.structure.client.editors.context.GuvnorStructureContext;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class GuvnorStructureContextTest {
    @Mock
    private RepositoryService repositoryService;
    private GuvnorStructureContext context;
    private ArrayList<Repository> repositories;
    private Collection<Repository> result;
    private Callback<Collection<Repository>> callback;

    @Before
    public void setUp() throws Exception {
        this.callback = (Callback)Mockito.spy((Object)new Callback<Collection<Repository>>(){

            public void callback(Collection<Repository> result) {
                GuvnorStructureContextTest.this.result = result;
            }
        });
        this.repositories = new ArrayList();
        this.repositories.add(TestUtil.makeRepository("my-repo", "master", "dev"));
        this.repositories.add(TestUtil.makeRepository("your-repo", "master", "release"));
        Mockito.when((Object)this.repositoryService.getRepositories()).thenReturn(this.repositories);
        this.context = new GuvnorStructureContext((Caller)new CallerMock((Object)this.repositoryService));
        this.getRepositories();
    }

    @Test
    public void testLoad() throws Exception {
        Assert.assertEquals((long)2L, (long)this.result.size());
        Collection<String> repositoryAliases = this.getRepositoryAliases();
        Assert.assertTrue((boolean)repositoryAliases.contains("my-repo"));
        Assert.assertTrue((boolean)repositoryAliases.contains("your-repo"));
    }

    @Test
    public void testReLoadRemembersBranches() throws Exception {
        this.context.changeBranch("your-repo", "release");
        this.context.getRepositories(this.callback);
        Assert.assertEquals((long)2L, (long)this.result.size());
        Assert.assertEquals((Object)"master", (Object)this.context.getCurrentBranch("my-repo"));
        Assert.assertEquals((Object)"release", (Object)this.context.getCurrentBranch("your-repo"));
        ((Callback)Mockito.verify(this.callback, (VerificationMode)Mockito.times((int)2))).callback((Object)Mockito.anyCollection());
    }

    @Test
    public void testReLoadPicksUpNewRepositories() throws Exception {
        this.repositories.add(TestUtil.makeRepository("my-new-repo", "master"));
        this.context.getRepositories(this.callback);
        Assert.assertEquals((long)3L, (long)this.result.size());
        Assert.assertEquals((Object)"master", (Object)this.context.getCurrentBranch("my-repo"));
        Assert.assertEquals((Object)"master", (Object)this.context.getCurrentBranch("your-repo"));
        Assert.assertEquals((Object)"master", (Object)this.context.getCurrentBranch("my-new-repo"));
        ((Callback)Mockito.verify(this.callback, (VerificationMode)Mockito.times((int)2))).callback((Object)Mockito.anyCollection());
    }

    @Test
    public void testReLoadPicksUpRemovedRepositories() throws Exception {
        this.repositories.remove(1);
        this.context.getRepositories(this.callback);
        Assert.assertEquals((long)1L, (long)this.result.size());
        Assert.assertEquals((Object)"master", (Object)this.context.getCurrentBranch("my-repo"));
        Assert.assertNull((Object)this.context.getCurrentBranch("your-repo"));
    }

    @Test
    public void testReLoadPicksUpRemovedBranch() throws Exception {
        Mockito.when((Object)this.repositories.get(0).getBranches()).thenReturn(Arrays.asList("dev"));
        Mockito.when((Object)this.repositories.get(0).getDefaultBranch()).thenReturn((Object)"dev");
        this.context.getRepositories(this.callback);
        Assert.assertEquals((Object)"dev", (Object)this.context.getCurrentBranch("my-repo"));
        Assert.assertEquals((Object)"master", (Object)this.context.getCurrentBranch("your-repo"));
    }

    @Test
    public void testNewRepository() throws Exception {
        this.context.onNewRepository(new NewRepositoryEvent(TestUtil.makeRepository("new-repo", "master")));
        Assert.assertEquals((Object)"master", (Object)this.context.getCurrentBranch("new-repo"));
    }

    @Test
    public void testRemoveRepository() throws Exception {
        this.context.onRepositoryRemoved(new RepositoryRemovedEvent(TestUtil.makeRepository("your-repo", new String[0])));
        Assert.assertNull((Object)this.context.getCurrentBranch("your-repo"));
    }

    private Collection<String> getRepositoryAliases() {
        ArrayList<String> repositoryAliases = new ArrayList<String>();
        for (Repository repository : this.result) {
            repositoryAliases.add(repository.getAlias());
        }
        return repositoryAliases;
    }

    @Test
    public void testLoadDefaultBranches() throws Exception {
        for (Repository repository : this.result) {
            Assert.assertEquals((Object)"master", (Object)this.context.getCurrentBranch(repository.getAlias()));
        }
    }

    @Test
    public void testChangeBranch() throws Exception {
        this.context.changeBranch("my-repo", "dev");
        for (Repository repository : this.result) {
            if (repository.getAlias().equals("my-repo")) {
                Assert.assertEquals((Object)"dev", (Object)this.context.getCurrentBranch(repository.getAlias()));
                continue;
            }
            Assert.assertEquals((Object)"master", (Object)this.context.getCurrentBranch(repository.getAlias()));
        }
    }

    private void getRepositories() {
        this.context.getRepositories(this.callback);
        ((Callback)Mockito.verify(this.callback)).callback((Object)Mockito.anyCollection());
    }
}

