/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class AuditEntitiesConfiguration {
    private final String auditTablePrefix;
    private final String auditTableSuffix;
    private final String originalIdPropName;
    private final String revisionFieldName;
    private final String revisionNumberPath;
    private final String revisionPropBasePath;
    private final String revisionTypePropName;
    private final String revisionTypePropType;
    private final String revisionInfoEntityName;
    private final Map<String, String> customAuditTablesNames;

    public AuditEntitiesConfiguration(Properties properties, String revisionInfoEntityName) {
        this.revisionInfoEntityName = revisionInfoEntityName;
        this.auditTablePrefix = properties.getProperty("org.hibernate.envers.auditTablePrefix", "");
        this.auditTableSuffix = properties.getProperty("org.hibernate.envers.auditTableSuffix", "_AUD");
        this.originalIdPropName = "originalId";
        this.revisionFieldName = properties.getProperty("org.hibernate.envers.revisionFieldName", "REV");
        this.revisionTypePropName = properties.getProperty("org.hibernate.envers.revisionTypeFieldName", "REVTYPE");
        this.revisionTypePropType = "byte";
        this.customAuditTablesNames = new HashMap<String, String>();
        this.revisionNumberPath = this.originalIdPropName + "." + this.revisionFieldName + ".id";
        this.revisionPropBasePath = this.originalIdPropName + "." + this.revisionFieldName + ".";
    }

    public String getOriginalIdPropName() {
        return this.originalIdPropName;
    }

    public String getRevisionFieldName() {
        return this.revisionFieldName;
    }

    public String getRevisionNumberPath() {
        return this.revisionNumberPath;
    }

    public String getRevisionPropPath(String propertyName) {
        return this.revisionPropBasePath + propertyName;
    }

    public String getRevisionTypePropName() {
        return this.revisionTypePropName;
    }

    public String getRevisionTypePropType() {
        return this.revisionTypePropType;
    }

    public String getRevisionInfoEntityName() {
        return this.revisionInfoEntityName;
    }

    public void addCustomAuditTableName(String entityName, String tableName) {
        this.customAuditTablesNames.put(entityName, tableName);
    }

    public String getAuditEntityName(String entityName) {
        return this.auditTablePrefix + entityName + this.auditTableSuffix;
    }

    public String getAuditTableName(String entityName, String tableName) {
        String customHistoryTableName = this.customAuditTablesNames.get(entityName);
        if (customHistoryTableName == null) {
            return this.auditTablePrefix + tableName + this.auditTableSuffix;
        }
        return customHistoryTableName;
    }
}

