/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.metadata;

import java.util.Map;
import java.util.Properties;
import org.dom4j.Element;
import org.hibernate.envers.configuration.metadata.MetadataTools;
import org.hibernate.envers.configuration.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.entities.mapper.SimpleMapperBuilder;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CustomType;
import org.hibernate.type.ImmutableType;
import org.hibernate.type.MutableType;
import org.hibernate.type.Type;

public final class BasicMetadataGenerator {
    boolean addBasic(Element parent, PropertyAuditingData propertyAuditingData, Value value, SimpleMapperBuilder mapper, boolean insertable, boolean key) {
        Type type = value.getType();
        if (type instanceof ImmutableType || type instanceof MutableType) {
            this.addSimpleValue(parent, propertyAuditingData, value, mapper, insertable, key);
        } else if (type instanceof CustomType || type instanceof CompositeCustomType) {
            this.addCustomValue(parent, propertyAuditingData, value, mapper, insertable, key);
        } else if ("org.hibernate.type.PrimitiveByteArrayBlobType".equals(type.getClass().getName())) {
            this.addSimpleValue(parent, propertyAuditingData, value, mapper, insertable, key);
        } else {
            return false;
        }
        return true;
    }

    private void addSimpleValue(Element parent, PropertyAuditingData propertyAuditingData, Value value, SimpleMapperBuilder mapper, boolean insertable, boolean key) {
        if (parent != null) {
            Element prop_mapping = MetadataTools.addProperty(parent, propertyAuditingData.getName(), value.getType().getName(), insertable, key);
            MetadataTools.addColumns(prop_mapping, value.getColumnIterator());
        }
        if (mapper != null) {
            mapper.add(propertyAuditingData.getPropertyData());
        }
    }

    private void addCustomValue(Element parent, PropertyAuditingData propertyAuditingData, Value value, SimpleMapperBuilder mapper, boolean insertable, boolean key) {
        if (parent != null) {
            Properties typeParameters;
            Element prop_mapping = MetadataTools.addProperty(parent, propertyAuditingData.getName(), null, insertable, key);
            Element type_mapping = prop_mapping.addElement("type");
            type_mapping.addAttribute("name", value.getType().getName());
            if (value instanceof SimpleValue && (typeParameters = ((SimpleValue)value).getTypeParameters()) != null) {
                for (Map.Entry<Object, Object> paramKeyValue : typeParameters.entrySet()) {
                    Element type_param = type_mapping.addElement("param");
                    type_param.addAttribute("name", (String)paramKeyValue.getKey());
                    type_param.setText((String)paramKeyValue.getValue());
                }
            }
            MetadataTools.addColumns(prop_mapping, value.getColumnIterator());
        }
        if (mapper != null) {
            mapper.add(propertyAuditingData.getPropertyData());
        }
    }
}

