/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.strategy;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public class ValidTimeAuditStrategy
implements AuditStrategy {
    public void perform(Session session, String entityName, AuditConfiguration auditCfg, Serializable id, Object data, Object revision) {
        AuditEntitiesConfiguration audEntCfg = auditCfg.getAuditEntCfg();
        String auditedEntityName = audEntCfg.getAuditEntityName(entityName);
        if (this.getRevisionType(auditCfg, data) != RevisionType.ADD) {
            QueryBuilder qb = new QueryBuilder(auditedEntityName, "e");
            IdMapper idMapper = auditCfg.getEntCfg().get(entityName).getIdMapper();
            idMapper.addIdEqualsToQuery(qb.getRootParameters(), id, auditCfg.getAuditEntCfg().getOriginalIdPropName(), true);
            this.updateLastRevision(session, auditCfg, qb, id, auditedEntityName, revision);
        }
        session.save(auditedEntityName, data);
    }

    public void performCollectionChange(Session session, AuditConfiguration auditCfg, PersistentCollectionChangeData persistentCollectionChangeData, Object revision) {
        if (this.getRevisionType(auditCfg, persistentCollectionChangeData.getData()) != RevisionType.ADD) {
            QueryBuilder qb = new QueryBuilder(persistentCollectionChangeData.getEntityName(), "e");
            String originalIdPropName = auditCfg.getAuditEntCfg().getOriginalIdPropName();
            Map originalId = (Map)persistentCollectionChangeData.getData().get(originalIdPropName);
            for (Map.Entry originalIdEntry : originalId.entrySet()) {
                if (auditCfg.getAuditEntCfg().getRevisionFieldName().equals(originalIdEntry.getKey())) continue;
                qb.getRootParameters().addWhereWithParam(originalIdPropName + "." + (String)originalIdEntry.getKey(), true, "=", originalIdEntry.getValue());
            }
            this.updateLastRevision(session, auditCfg, qb, originalId, persistentCollectionChangeData.getEntityName(), revision);
        }
        session.save(persistentCollectionChangeData.getEntityName(), persistentCollectionChangeData.getData());
    }

    public void addEntityAtRevisionRestriction(GlobalConfiguration globalCfg, QueryBuilder rootQueryBuilder, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData idData, String revisionPropertyPath, String originalIdPropertyName, String alias1, String alias2) {
        Parameters rootParameters = rootQueryBuilder.getRootParameters();
        this.addRevisionRestriction(rootParameters, revisionProperty, revisionEndProperty, addAlias);
    }

    public void addAssociationAtRevisionRestriction(QueryBuilder rootQueryBuilder, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData referencingIdData, String versionsMiddleEntityName, String eeOriginalIdPropertyPath, String revisionPropertyPath, String originalIdPropertyName, MiddleComponentData ... componentDatas) {
        Parameters rootParameters = rootQueryBuilder.getRootParameters();
        this.addRevisionRestriction(rootParameters, revisionProperty, revisionEndProperty, addAlias);
    }

    private void addRevisionRestriction(Parameters rootParameters, String revisionProperty, String revisionEndProperty, boolean addAlias) {
        Parameters subParm = rootParameters.addSubParameters("or");
        rootParameters.addWhereWithNamedParam(revisionProperty, addAlias, "<=", "revision");
        subParm.addWhereWithNamedParam(revisionEndProperty + ".id", addAlias, ">", "revision");
        subParm.addWhere(revisionEndProperty, addAlias, "is", "null", false);
    }

    private RevisionType getRevisionType(AuditConfiguration auditCfg, Object data) {
        return (RevisionType)((Object)((Map)data).get(auditCfg.getAuditEntCfg().getRevisionTypePropName()));
    }

    private void updateLastRevision(Session session, AuditConfiguration auditCfg, QueryBuilder qb, Object id, String auditedEntityName, Object revision) {
        String revisionEndFieldName = auditCfg.getAuditEntCfg().getRevisionEndFieldName();
        qb.getRootParameters().addWhere(revisionEndFieldName, true, "is", "null", false);
        List l = qb.toQuery(session).list();
        if (l.size() != 1) {
            throw new RuntimeException("Cannot find previous revision for entity " + auditedEntityName + " and id " + id);
        }
        Object previousData = l.get(0);
        ((Map)previousData).put(revisionEndFieldName, revision);
        session.save(auditedEntityName, previousData);
    }
}

