/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.tools.Pair;
import org.hibernate.proxy.HibernateProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <E> Set<E> newHashSet() {
        return new HashSet();
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static boolean entitiesEqual(SessionImplementor session, String entityName, Object obj1, Object obj2) {
        Object id1 = Tools.getIdentifier(session, entityName, obj1);
        Object id2 = Tools.getIdentifier(session, entityName, obj2);
        return Tools.objectsEqual(id1, id2);
    }

    public static Object getIdentifier(SessionImplementor session, String entityName, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)obj;
            return hibernateProxy.getHibernateLazyInitializer().getIdentifier();
        }
        return session.getEntityPersister(entityName, obj).getIdentifier(obj, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getTargetFromProxy(SessionFactoryImplementor sessionFactoryImplementor, HibernateProxy proxy) {
        if (!proxy.getHibernateLazyInitializer().isUninitialized()) {
            return proxy.getHibernateLazyInitializer().getImplementation();
        }
        SessionImplementor sessionImplementor = proxy.getHibernateLazyInitializer().getSession();
        Session tempSession = sessionImplementor == null ? sessionFactoryImplementor.openTemporarySession() : sessionImplementor.getFactory().openTemporarySession();
        try {
            Object target;
            Object object = target = tempSession.get(proxy.getHibernateLazyInitializer().getEntityName(), proxy.getHibernateLazyInitializer().getIdentifier());
            return object;
        }
        finally {
            tempSession.close();
        }
    }

    public static boolean objectsEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    public static <T> List<T> iteratorToList(Iterator<T> iter) {
        ArrayList<T> ret = new ArrayList<T>();
        while (iter.hasNext()) {
            ret.add(iter.next());
        }
        return ret;
    }

    public static boolean iteratorsContentEqual(Iterator iter1, Iterator iter2) {
        while (iter1.hasNext() && iter2.hasNext()) {
            if (iter1.next().equals(iter2.next())) continue;
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }

    public static <T> List<Pair<Integer, T>> listToIndexElementPairList(List<T> list) {
        ArrayList<Pair<Integer, T>> ret = new ArrayList<Pair<Integer, T>>();
        Iterator<T> listIter = list.iterator();
        for (int i = 0; i < list.size(); ++i) {
            ret.add(Pair.make(i, listIter.next()));
        }
        return ret;
    }

    public static String getProperty(Properties properties, String propertyName, String legacyPropertyName, String defaultValue) {
        String value = properties.getProperty(propertyName, null);
        if (value == null) {
            return properties.getProperty(legacyPropertyName, defaultValue);
        }
        return value;
    }
}

