/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.metadata.reader;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.JoinColumn;
import javax.persistence.MapKey;
import javax.persistence.Version;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.AuditMappedBy;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.ModificationStore;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.configuration.metadata.reader.AuditedPropertiesHolder;
import org.hibernate.envers.configuration.metadata.reader.ComponentAuditedPropertiesReader;
import org.hibernate.envers.configuration.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.configuration.metadata.reader.PersistentPropertiesSource;
import org.hibernate.envers.configuration.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.tools.MappingTools;
import org.hibernate.envers.tools.Tools;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditedPropertiesReader {
    protected final ModificationStore defaultStore;
    private final PersistentPropertiesSource persistentPropertiesSource;
    private final AuditedPropertiesHolder auditedPropertiesHolder;
    private final GlobalConfiguration globalCfg;
    private final ReflectionManager reflectionManager;
    private final String propertyNamePrefix;
    private final Set<String> propertyAccessedPersistentProperties;
    private final Set<String> fieldAccessedPersistentProperties;
    private static AuditJoinTable DEFAULT_AUDIT_JOIN_TABLE = new AuditJoinTable(){

        @Override
        public String name() {
            return "";
        }

        @Override
        public String schema() {
            return "";
        }

        @Override
        public String catalog() {
            return "";
        }

        @Override
        public JoinColumn[] inverseJoinColumns() {
            return new JoinColumn[0];
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.getClass();
        }
    };

    public AuditedPropertiesReader(ModificationStore defaultStore, PersistentPropertiesSource persistentPropertiesSource, AuditedPropertiesHolder auditedPropertiesHolder, GlobalConfiguration globalCfg, ReflectionManager reflectionManager, String propertyNamePrefix) {
        this.defaultStore = defaultStore;
        this.persistentPropertiesSource = persistentPropertiesSource;
        this.auditedPropertiesHolder = auditedPropertiesHolder;
        this.globalCfg = globalCfg;
        this.reflectionManager = reflectionManager;
        this.propertyNamePrefix = propertyNamePrefix;
        this.propertyAccessedPersistentProperties = Tools.newHashSet();
        this.fieldAccessedPersistentProperties = Tools.newHashSet();
    }

    public void read() {
        this.readPersistentPropertiesAccess();
        this.addPropertiesFromClass(this.persistentPropertiesSource.getXClass());
    }

    private void readPersistentPropertiesAccess() {
        Iterator<Property> propertyIter = this.persistentPropertiesSource.getPropertyIterator();
        while (propertyIter.hasNext()) {
            Property property = propertyIter.next();
            if ("field".equals(property.getPropertyAccessorName())) {
                this.fieldAccessedPersistentProperties.add(property.getName());
                continue;
            }
            this.propertyAccessedPersistentProperties.add(property.getName());
        }
    }

    private void addPropertiesFromClass(XClass clazz) {
        Audited allClassAudited = (Audited)clazz.getAnnotation(Audited.class);
        this.addFromProperties(clazz.getDeclaredProperties("field"), "field", this.fieldAccessedPersistentProperties, allClassAudited);
        this.addFromProperties(clazz.getDeclaredProperties("property"), "property", this.propertyAccessedPersistentProperties, allClassAudited);
        if (allClassAudited != null || !this.auditedPropertiesHolder.isEmpty()) {
            XClass superclazz = clazz.getSuperclass();
            if (!clazz.isInterface() && !"java.lang.Object".equals(superclazz.getName())) {
                this.addPropertiesFromClass(superclazz);
            }
        }
    }

    private void addFromProperties(Iterable<XProperty> properties, String accessType, Set<String> persistentProperties, Audited allClassAudited) {
        for (XProperty property : properties) {
            if (!persistentProperties.contains(property.getName()) || this.auditedPropertiesHolder.contains(property.getName())) continue;
            Value propertyValue = this.persistentPropertiesSource.getProperty(property.getName()).getValue();
            if (propertyValue instanceof Component) {
                this.addFromComponentProperty(property, accessType, (Component)propertyValue, allClassAudited);
                continue;
            }
            this.addFromNotComponentProperty(property, accessType, allClassAudited);
        }
    }

    private void addFromComponentProperty(XProperty property, String accessType, Component propertyValue, Audited allClassAudited) {
        ComponentAuditingData componentData = new ComponentAuditingData();
        boolean isAudited = this.fillPropertyData(property, componentData, accessType, allClassAudited);
        ComponentPropertiesSource componentPropertiesSource = new ComponentPropertiesSource(propertyValue);
        ComponentAuditedPropertiesReader audPropReader = new ComponentAuditedPropertiesReader(ModificationStore.FULL, componentPropertiesSource, componentData, this.globalCfg, this.reflectionManager, this.propertyNamePrefix + MappingTools.createComponentPrefix(property.getName()));
        audPropReader.read();
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(property.getName(), componentData);
        }
    }

    private void addFromNotComponentProperty(XProperty property, String accessType, Audited allClassAudited) {
        PropertyAuditingData propertyData = new PropertyAuditingData();
        boolean isAudited = this.fillPropertyData(property, propertyData, accessType, allClassAudited);
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(property.getName(), propertyData);
        }
    }

    private boolean fillPropertyData(XProperty property, PropertyAuditingData propertyData, String accessType, Audited allClassAudited) {
        Version jpaVer;
        NotAudited unVer = (NotAudited)property.getAnnotation(NotAudited.class);
        if (unVer != null) {
            return false;
        }
        if (this.globalCfg.isDoNotAuditOptimisticLockingField() && (jpaVer = (Version)property.getAnnotation(Version.class)) != null) {
            return false;
        }
        if (!this.checkAudited(property, propertyData, allClassAudited)) {
            return false;
        }
        propertyData.setName(this.propertyNamePrefix + property.getName());
        propertyData.setBeanName(property.getName());
        propertyData.setAccessType(accessType);
        this.addPropertyJoinTables(property, propertyData);
        this.addPropertyAuditingOverrides(property, propertyData);
        if (!this.processPropertyAuditingOverrides(property, propertyData)) {
            return false;
        }
        this.addPropertyMapKey(property, propertyData);
        this.setPropertyAuditMappedBy(property, propertyData);
        return true;
    }

    protected boolean checkAudited(XProperty property, PropertyAuditingData propertyData, Audited allClassAudited) {
        Audited aud;
        Audited audited = aud = property.isAnnotationPresent(Audited.class) ? (Audited)property.getAnnotation(Audited.class) : allClassAudited;
        if (aud != null) {
            propertyData.setStore(aud.modStore());
            propertyData.setRelationTargetAuditMode(aud.targetAuditMode());
            return true;
        }
        return false;
    }

    private void setPropertyAuditMappedBy(XProperty property, PropertyAuditingData propertyData) {
        AuditMappedBy auditMappedBy = (AuditMappedBy)property.getAnnotation(AuditMappedBy.class);
        if (auditMappedBy != null) {
            propertyData.setAuditMappedBy(auditMappedBy.mappedBy());
            if (!"".equals(auditMappedBy.positionMappedBy())) {
                propertyData.setPositionMappedBy(auditMappedBy.positionMappedBy());
            }
        }
    }

    private void addPropertyMapKey(XProperty property, PropertyAuditingData propertyData) {
        MapKey mapKey = (MapKey)property.getAnnotation(MapKey.class);
        if (mapKey != null) {
            propertyData.setMapKey(mapKey.name());
        }
    }

    private void addPropertyJoinTables(XProperty property, PropertyAuditingData propertyData) {
        AuditJoinTable joinTable = (AuditJoinTable)property.getAnnotation(AuditJoinTable.class);
        if (joinTable != null) {
            propertyData.setJoinTable(joinTable);
        } else {
            propertyData.setJoinTable(DEFAULT_AUDIT_JOIN_TABLE);
        }
    }

    private void addPropertyAuditingOverrides(XProperty property, PropertyAuditingData propertyData) {
        AuditOverrides annotationOverrides;
        AuditOverride annotationOverride = (AuditOverride)property.getAnnotation(AuditOverride.class);
        if (annotationOverride != null) {
            propertyData.addAuditingOverride(annotationOverride);
        }
        if ((annotationOverrides = (AuditOverrides)property.getAnnotation(AuditOverrides.class)) != null) {
            propertyData.addAuditingOverrides(annotationOverrides);
        }
    }

    private boolean processPropertyAuditingOverrides(XProperty property, PropertyAuditingData propertyData) {
        if (this.auditedPropertiesHolder instanceof ComponentAuditingData) {
            List<AuditOverride> overrides = ((ComponentAuditingData)this.auditedPropertiesHolder).getAuditingOverrides();
            for (AuditOverride override : overrides) {
                if (!property.getName().equals(override.name())) continue;
                if (!override.isAudited()) {
                    return false;
                }
                if (override.auditJoinTable() == null) continue;
                propertyData.setJoinTable(override.auditJoinTable());
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentPropertiesSource
    implements PersistentPropertiesSource {
        private final XClass xclass;
        private final Component component;

        private ComponentPropertiesSource(Component component) {
            try {
                this.xclass = AuditedPropertiesReader.this.reflectionManager.classForName(component.getComponentClassName(), this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException((Throwable)e);
            }
            this.component = component;
        }

        @Override
        public Iterator<Property> getPropertyIterator() {
            return this.component.getPropertyIterator();
        }

        @Override
        public Property getProperty(String propertyName) {
            return this.component.getProperty(propertyName);
        }

        @Override
        public XClass getXClass() {
            return this.xclass;
        }
    }
}

