/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event;

import java.util.Map;
import org.hibernate.HibernateLogger;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.event.EnversListenerDuplicationStrategy;
import org.hibernate.envers.event.EnversPostCollectionRecreateEventListenerImpl;
import org.hibernate.envers.event.EnversPostDeleteEventListenerImpl;
import org.hibernate.envers.event.EnversPostInsertEventListenerImpl;
import org.hibernate.envers.event.EnversPostUpdateEventListenerImpl;
import org.hibernate.envers.event.EnversPreCollectionRemoveEventListenerImpl;
import org.hibernate.envers.event.EnversPreCollectionUpdateEventListenerImpl;
import org.hibernate.event.EventType;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreCollectionRemoveEventListener;
import org.hibernate.event.PreCollectionUpdateEventListener;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.event.spi.DuplicationStrategy;
import org.hibernate.service.event.spi.EventListenerRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.spi.Integrator;
import org.jboss.logging.Logger;

public class EnversIntegrator
implements Integrator {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)EnversIntegrator.class.getName());
    public static final String AUTO_REGISTER = "hibernate.listeners.envers.autoRegister";

    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        boolean autoRegister = ConfigurationHelper.getBoolean((String)AUTO_REGISTER, (Map)configuration.getProperties(), (boolean)true);
        if (!autoRegister) {
            LOG.debug((Object)"Skipping Envers listener auto registration");
            return;
        }
        EventListenerRegistry listenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy((DuplicationStrategy)EnversListenerDuplicationStrategy.INSTANCE);
        AuditConfiguration enversConfiguration = AuditConfiguration.getFor(configuration);
        if (enversConfiguration.getEntCfg().hasAuditedEntities()) {
            listenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{new EnversPostDeleteEventListenerImpl(enversConfiguration)});
            listenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{new EnversPostInsertEventListenerImpl(enversConfiguration)});
            listenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{new EnversPostUpdateEventListenerImpl(enversConfiguration)});
            listenerRegistry.appendListeners(EventType.POST_COLLECTION_RECREATE, (Object[])new PostCollectionRecreateEventListener[]{new EnversPostCollectionRecreateEventListenerImpl(enversConfiguration)});
            listenerRegistry.appendListeners(EventType.PRE_COLLECTION_REMOVE, (Object[])new PreCollectionRemoveEventListener[]{new EnversPreCollectionRemoveEventListenerImpl(enversConfiguration)});
            listenerRegistry.appendListeners(EventType.PRE_COLLECTION_UPDATE, (Object[])new PreCollectionUpdateEventListener[]{new EnversPreCollectionUpdateEventListenerImpl(enversConfiguration)});
        }
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

