/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event;

import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.event.BaseEnversEventListener;
import org.hibernate.envers.synchronization.AuditProcess;
import org.hibernate.envers.synchronization.work.AddWorkUnit;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;

public class EnversPostInsertEventListenerImpl
extends BaseEnversEventListener
implements PostInsertEventListener {
    public EnversPostInsertEventListenerImpl(AuditConfiguration enversConfiguration) {
        super(enversConfiguration);
    }

    public void onPostInsert(PostInsertEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getAuditConfiguration().getEntCfg().isVersioned(entityName)) {
            AuditProcess auditProcess = this.getAuditConfiguration().getSyncManager().get(event.getSession());
            AddWorkUnit workUnit = new AddWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.getAuditConfiguration(), event.getId(), event.getPersister(), event.getState());
            auditProcess.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event.getPersister(), entityName, event.getState(), null, (SessionImplementor)event.getSession());
            }
        }
    }
}

