/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.mapper.PropertyMapper;
import org.hibernate.envers.entities.mapper.relation.AbstractCollectionMapper;
import org.hibernate.envers.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.lazy.initializor.Initializor;
import org.hibernate.envers.entities.mapper.relation.lazy.initializor.MapCollectionInitializor;
import org.hibernate.envers.reader.AuditReaderImplementor;

public final class MapCollectionMapper<T extends Map>
extends AbstractCollectionMapper<T>
implements PropertyMapper {
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public MapCollectionMapper(CommonCollectionMapperData commonCollectionMapperData, Class<? extends T> collectionClass, Class<? extends T> proxyClass, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        super(commonCollectionMapperData, collectionClass, proxyClass);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected Initializor<T> getInitializor(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Object primaryKey, Number revision) {
        return new MapCollectionInitializor(verCfg, versionsReader, this.commonCollectionMapperData.getQueryGenerator(), primaryKey, revision, this.collectionClass, this.elementComponentData, this.indexComponentData);
    }

    @Override
    protected Collection getNewCollectionContent(PersistentCollection newCollection) {
        if (newCollection == null) {
            return null;
        }
        return ((Map)newCollection).entrySet();
    }

    @Override
    protected Collection getOldCollectionContent(Serializable oldCollection) {
        if (oldCollection == null) {
            return null;
        }
        return ((Map)((Object)oldCollection)).entrySet();
    }

    @Override
    protected void mapToMapFromObject(Map<String, Object> data, Object changed) {
        this.elementComponentData.getComponentMapper().mapToMapFromObject(data, ((Map.Entry)changed).getValue());
        this.indexComponentData.getComponentMapper().mapToMapFromObject(data, ((Map.Entry)changed).getKey());
    }
}

