/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event;

import java.io.Serializable;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.RelationDescription;
import org.hibernate.envers.entities.RelationType;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.event.EnversListener;
import org.hibernate.envers.synchronization.AuditProcess;
import org.hibernate.envers.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.tools.Tools;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;

public abstract class BaseEnversEventListener
implements EnversListener {
    private AuditConfiguration enversConfiguration;

    protected BaseEnversEventListener(AuditConfiguration enversConfiguration) {
        this.enversConfiguration = enversConfiguration;
    }

    @Override
    public AuditConfiguration getAuditConfiguration() {
        return this.enversConfiguration;
    }

    protected final void generateBidirectionalCollectionChangeWorkUnits(AuditProcess auditProcess, EntityPersister entityPersister, String entityName, Object[] newState, Object[] oldState, SessionImplementor session) {
        if (!this.enversConfiguration.getGlobalCfg().isGenerateRevisionsForCollections()) {
            return;
        }
        String[] propertyNames = entityPersister.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            IdMapper idMapper;
            Serializable id;
            String toEntityName;
            HibernateProxy hibernateProxy;
            Object newValue;
            String propertyName = propertyNames[i];
            RelationDescription relDesc = this.enversConfiguration.getEntCfg().getRelationDescription(entityName, propertyName);
            if (relDesc == null || !relDesc.isBidirectional() || relDesc.getRelationType() != RelationType.TO_ONE || !relDesc.isInsertable()) continue;
            Object oldValue = oldState == null ? null : oldState[i];
            Object object = newValue = newState == null ? null : newState[i];
            if (Tools.entitiesEqual(session, relDesc.getToEntityName(), oldValue, newValue)) continue;
            if (newValue != null) {
                if (newValue instanceof HibernateProxy) {
                    hibernateProxy = (HibernateProxy)newValue;
                    toEntityName = session.bestGuessEntityName(newValue);
                    id = hibernateProxy.getHibernateLazyInitializer().getIdentifier();
                    newValue = Tools.getTargetFromProxy(session.getFactory(), hibernateProxy);
                } else {
                    toEntityName = session.guessEntityName(newValue);
                    idMapper = this.enversConfiguration.getEntCfg().get(toEntityName).getIdMapper();
                    id = (Serializable)idMapper.mapToIdFromEntity(newValue);
                }
                auditProcess.addWorkUnit(new CollectionChangeWorkUnit(session, toEntityName, this.enversConfiguration, id, newValue));
            }
            if (oldValue == null) continue;
            if (oldValue instanceof HibernateProxy) {
                hibernateProxy = (HibernateProxy)oldValue;
                toEntityName = session.bestGuessEntityName(oldValue);
                id = hibernateProxy.getHibernateLazyInitializer().getIdentifier();
                oldValue = Tools.getTargetFromProxy(session.getFactory(), hibernateProxy);
            } else {
                toEntityName = session.guessEntityName(oldValue);
                idMapper = this.enversConfiguration.getEntCfg().get(toEntityName).getIdMapper();
                id = (Serializable)idMapper.mapToIdFromEntity(oldValue);
            }
            auditProcess.addWorkUnit(new CollectionChangeWorkUnit(session, toEntityName, this.enversConfiguration, id, oldValue));
        }
    }
}

