/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.strategy;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.synchronization.SessionCacheCleaner;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;
import org.hibernate.property.Getter;

public class ValidityAuditStrategy
implements AuditStrategy {
    private Getter revisionTimestampGetter = null;
    private final SessionCacheCleaner sessionCacheCleaner = new SessionCacheCleaner();

    @Override
    public void perform(Session session, String entityName, AuditConfiguration auditCfg, Serializable id, Object data, Object revision) {
        AuditEntitiesConfiguration audEntCfg = auditCfg.getAuditEntCfg();
        String auditedEntityName = audEntCfg.getAuditEntityName(entityName);
        if (this.getRevisionType(auditCfg, data) != RevisionType.ADD) {
            QueryBuilder qb = new QueryBuilder(auditedEntityName, "ee__");
            IdMapper idMapper = auditCfg.getEntCfg().get(entityName).getIdMapper();
            idMapper.addIdEqualsToQuery(qb.getRootParameters(), id, auditCfg.getAuditEntCfg().getOriginalIdPropName(), true);
            this.addEndRevisionNullRestriction(auditCfg, qb);
            List l = qb.toQuery(session).setLockOptions(LockOptions.UPGRADE).list();
            this.updateLastRevision(session, auditCfg, l, id, auditedEntityName, revision);
        }
        session.save(auditedEntityName, data);
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, data);
    }

    @Override
    public void performCollectionChange(Session session, AuditConfiguration auditCfg, PersistentCollectionChangeData persistentCollectionChangeData, Object revision) {
        QueryBuilder qb = new QueryBuilder(persistentCollectionChangeData.getEntityName(), "ee__");
        String originalIdPropName = auditCfg.getAuditEntCfg().getOriginalIdPropName();
        Map originalId = (Map)persistentCollectionChangeData.getData().get(originalIdPropName);
        for (Map.Entry originalIdEntry : originalId.entrySet()) {
            if (auditCfg.getAuditEntCfg().getRevisionFieldName().equals(originalIdEntry.getKey())) continue;
            qb.getRootParameters().addWhereWithParam(originalIdPropName + "." + (String)originalIdEntry.getKey(), true, "=", originalIdEntry.getValue());
        }
        this.addEndRevisionNullRestriction(auditCfg, qb);
        List l = qb.toQuery(session).setLockOptions(LockOptions.UPGRADE).list();
        if (l.size() > 0) {
            this.updateLastRevision(session, auditCfg, l, originalId, persistentCollectionChangeData.getEntityName(), revision);
        }
        session.save(persistentCollectionChangeData.getEntityName(), persistentCollectionChangeData.getData());
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, persistentCollectionChangeData.getData());
    }

    private void addEndRevisionNullRestriction(AuditConfiguration auditCfg, QueryBuilder qb) {
        qb.getRootParameters().addWhere(auditCfg.getAuditEntCfg().getRevisionEndFieldName(), true, "is", "null", false);
    }

    @Override
    public void addEntityAtRevisionRestriction(GlobalConfiguration globalCfg, QueryBuilder rootQueryBuilder, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData idData, String revisionPropertyPath, String originalIdPropertyName, String alias1, String alias2) {
        Parameters rootParameters = rootQueryBuilder.getRootParameters();
        this.addRevisionRestriction(rootParameters, revisionProperty, revisionEndProperty, addAlias);
    }

    @Override
    public void addAssociationAtRevisionRestriction(QueryBuilder rootQueryBuilder, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData referencingIdData, String versionsMiddleEntityName, String eeOriginalIdPropertyPath, String revisionPropertyPath, String originalIdPropertyName, MiddleComponentData ... componentDatas) {
        Parameters rootParameters = rootQueryBuilder.getRootParameters();
        this.addRevisionRestriction(rootParameters, revisionProperty, revisionEndProperty, addAlias);
    }

    public void setRevisionTimestampGetter(Getter revisionTimestampGetter) {
        this.revisionTimestampGetter = revisionTimestampGetter;
    }

    private void addRevisionRestriction(Parameters rootParameters, String revisionProperty, String revisionEndProperty, boolean addAlias) {
        Parameters subParm = rootParameters.addSubParameters("or");
        rootParameters.addWhereWithNamedParam(revisionProperty, addAlias, "<=", "revision");
        subParm.addWhereWithNamedParam(revisionEndProperty + ".id", addAlias, ">", "revision");
        subParm.addWhere(revisionEndProperty, addAlias, "is", "null", false);
    }

    private RevisionType getRevisionType(AuditConfiguration auditCfg, Object data) {
        return (RevisionType)((Object)((Map)data).get(auditCfg.getAuditEntCfg().getRevisionTypePropName()));
    }

    private void updateLastRevision(Session session, AuditConfiguration auditCfg, List<Object> l, Object id, String auditedEntityName, Object revision) {
        Object previousData;
        if (l.size() == 1) {
            previousData = l.get(0);
            String revisionEndFieldName = auditCfg.getAuditEntCfg().getRevisionEndFieldName();
            ((Map)previousData).put(revisionEndFieldName, revision);
            if (auditCfg.getAuditEntCfg().isRevisionEndTimestampEnabled()) {
                String revEndTimestampFieldName = auditCfg.getAuditEntCfg().getRevisionEndTimestampFieldName();
                Object revEndTimestampObj = this.revisionTimestampGetter.get(revision);
                Date revisionEndTimestamp = revEndTimestampObj instanceof Date ? (Date)revEndTimestampObj : new Date((Long)revEndTimestampObj);
                ((Map)previousData).put(revEndTimestampFieldName, revisionEndTimestamp);
            }
        } else {
            throw new RuntimeException("Cannot find previous revision for entity " + auditedEntityName + " and id " + id);
        }
        session.save(auditedEntityName, previousData);
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, previousData);
    }
}

