/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.CriteriaTools;
import org.hibernate.envers.query.property.PropertyNameGetter;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public class BetweenAuditExpression
implements AuditCriterion {
    private PropertyNameGetter propertyNameGetter;
    private Object lo;
    private Object hi;

    public BetweenAuditExpression(PropertyNameGetter propertyNameGetter, Object lo, Object hi) {
        this.propertyNameGetter = propertyNameGetter;
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public void addToQuery(AuditConfiguration auditCfg, String entityName, QueryBuilder qb, Parameters parameters) {
        String propertyName = this.propertyNameGetter.get(auditCfg);
        CriteriaTools.checkPropertyNotARelation(auditCfg, entityName, propertyName);
        Parameters subParams = parameters.addSubParameters("and");
        subParams.addWhereWithParam(propertyName, ">=", this.lo);
        subParams.addWhereWithParam(propertyName, "<=", this.hi);
    }
}

