/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.revisioninfo;

import java.util.Date;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class RevisionInfoQueryCreator {
    private final String revisionInfoEntityName;
    private final String revisionInfoIdName;
    private final String revisionInfoTimestampName;
    private final boolean timestampAsDate;

    public RevisionInfoQueryCreator(String revisionInfoEntityName, String revisionInfoIdName, String revisionInfoTimestampName, boolean timestampAsDate) {
        this.revisionInfoEntityName = revisionInfoEntityName;
        this.revisionInfoIdName = revisionInfoIdName;
        this.revisionInfoTimestampName = revisionInfoTimestampName;
        this.timestampAsDate = timestampAsDate;
    }

    public Criteria getRevisionDateQuery(Session session, Number revision) {
        return session.createCriteria(this.revisionInfoEntityName).setProjection((Projection)Projections.property((String)this.revisionInfoTimestampName)).add(Restrictions.eq((String)this.revisionInfoIdName, (Object)revision));
    }

    public Criteria getRevisionNumberForDateQuery(Session session, Date date) {
        return session.createCriteria(this.revisionInfoEntityName).setProjection((Projection)Projections.max((String)this.revisionInfoIdName)).add((Criterion)Restrictions.le((String)this.revisionInfoTimestampName, (Object)(this.timestampAsDate ? date : Long.valueOf(date.getTime()))));
    }

    public Criteria getRevisionsQuery(Session session, Set<Number> revisions) {
        return session.createCriteria(this.revisionInfoEntityName).add(Restrictions.in((String)this.revisionInfoIdName, revisions));
    }
}

