/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.RelationDescription;
import org.hibernate.envers.entities.RelationType;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.query.property.PropertyNameGetter;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.Type;

public class CriteriaTools {
    private CriteriaTools() {
    }

    public static void checkPropertyNotARelation(AuditConfiguration verCfg, String entityName, String propertyName) throws AuditException {
        if (verCfg.getEntCfg().get(entityName).isRelation(propertyName)) {
            throw new AuditException("This criterion cannot be used on a property that is a relation to another property.");
        }
    }

    public static RelationDescription getRelatedEntity(AuditConfiguration verCfg, String entityName, String propertyName) throws AuditException {
        RelationDescription relationDesc = verCfg.getEntCfg().getRelationDescription(entityName, propertyName);
        if (relationDesc == null) {
            return null;
        }
        if (relationDesc.getRelationType() == RelationType.TO_ONE) {
            return relationDesc;
        }
        throw new AuditException("This type of relation (" + entityName + "." + propertyName + ") isn't supported and can't be used in queries.");
    }

    public static String determinePropertyName(AuditConfiguration auditCfg, AuditReaderImplementor versionsReader, String entityName, PropertyNameGetter propertyNameGetter) {
        return CriteriaTools.determinePropertyName(auditCfg, versionsReader, entityName, propertyNameGetter.get(auditCfg));
    }

    public static String determinePropertyName(AuditConfiguration auditCfg, AuditReaderImplementor versionsReader, String entityName, String propertyName) {
        SessionFactoryImplementor sessionFactory = versionsReader.getSessionImplementor().getFactory();
        if ("$$id$$".equals(propertyName)) {
            String identifierPropertyName = sessionFactory.getEntityPersister(entityName).getIdentifierPropertyName();
            propertyName = auditCfg.getAuditEntCfg().getOriginalIdPropName() + "." + identifierPropertyName;
        } else {
            List<String> identifierPropertyNames = CriteriaTools.identifierPropertyNames(sessionFactory, entityName);
            if (identifierPropertyNames.contains(propertyName)) {
                propertyName = auditCfg.getAuditEntCfg().getOriginalIdPropName() + "." + propertyName;
            }
        }
        return propertyName;
    }

    private static List<String> identifierPropertyNames(SessionFactoryImplementor sessionFactory, String entityName) {
        String identifierPropertyName = sessionFactory.getEntityPersister(entityName).getIdentifierPropertyName();
        if (identifierPropertyName != null) {
            return Arrays.asList(identifierPropertyName);
        }
        Type identifierType = sessionFactory.getEntityPersister(entityName).getIdentifierType();
        if (identifierType instanceof EmbeddedComponentType) {
            EmbeddedComponentType embeddedComponentType = (EmbeddedComponentType)identifierType;
            return Arrays.asList(embeddedComponentType.getPropertyNames());
        }
        return Collections.EMPTY_LIST;
    }
}

