/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.RelationDescription;
import org.hibernate.envers.entities.RelationType;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.query.property.PropertyNameGetter;
import org.hibernate.envers.reader.AuditReaderImplementor;

public class CriteriaTools {
    private CriteriaTools() {
    }

    public static void checkPropertyNotARelation(AuditConfiguration verCfg, String entityName, String propertyName) throws AuditException {
        if (verCfg.getEntCfg().get(entityName).isRelation(propertyName)) {
            throw new AuditException("This criterion cannot be used on a property that is a relation to another property.");
        }
    }

    public static RelationDescription getRelatedEntity(AuditConfiguration verCfg, String entityName, String propertyName) throws AuditException {
        RelationDescription relationDesc = verCfg.getEntCfg().getRelationDescription(entityName, propertyName);
        if (relationDesc == null) {
            return null;
        }
        if (relationDesc.getRelationType() == RelationType.TO_ONE) {
            return relationDesc;
        }
        throw new AuditException("This type of relation (" + entityName + "." + propertyName + ") isn't supported and can't be used in queries.");
    }

    public static String determinePropertyName(AuditConfiguration auditCfg, AuditReaderImplementor versionsReader, String entityName, PropertyNameGetter propertyNameGetter) {
        return CriteriaTools.determinePropertyName(auditCfg, versionsReader, entityName, propertyNameGetter.get(auditCfg));
    }

    public static String determinePropertyName(AuditConfiguration auditCfg, AuditReaderImplementor versionsReader, String entityName, String propertyName) {
        if ("$$id$$".equals(propertyName)) {
            String identifierPropertyName = versionsReader.getSessionImplementor().getFactory().getEntityPersister(entityName).getIdentifierPropertyName();
            propertyName = auditCfg.getAuditEntCfg().getOriginalIdPropName() + "." + identifierPropertyName;
        }
        return propertyName;
    }
}

