/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.query;

import java.util.Collections;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public final class OneAuditEntityQueryGenerator
extends AbstractRelationQueryGenerator {
    private final String queryString;

    public OneAuditEntityQueryGenerator(GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, AuditStrategy auditStrategy, MiddleIdData referencingIdData, String referencedEntityName, MiddleIdData referencedIdData, boolean revisionTypeInId) {
        super(verEntCfg, referencingIdData, revisionTypeInId);
        String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
        String originalIdPropertyName = verEntCfg.getOriginalIdPropName();
        String versionsReferencedEntityName = verEntCfg.getAuditEntityName(referencedEntityName);
        QueryBuilder qb = new QueryBuilder(versionsReferencedEntityName, "e__");
        qb.addProjection(null, "e__", false, false);
        Parameters rootParameters = qb.getRootParameters();
        referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(rootParameters, null, true);
        auditStrategy.addEntityAtRevisionRestriction(globalCfg, qb, revisionPropertyPath, verEntCfg.getRevisionEndFieldName(), true, referencedIdData, revisionPropertyPath, originalIdPropertyName, "e__", "e2__");
        rootParameters.addWhereWithNamedParam(this.getRevisionTypePath(), false, "!=", "delrevisiontype");
        StringBuilder sb = new StringBuilder();
        qb.build(sb, Collections.<String, Object>emptyMap());
        this.queryString = sb.toString();
    }

    @Override
    protected String getQueryString() {
        return this.queryString;
    }
}

