/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event;

import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.event.BaseEnversEventListener;
import org.hibernate.envers.synchronization.AuditProcess;
import org.hibernate.envers.synchronization.work.DelWorkUnit;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class EnversPostDeleteEventListenerImpl
extends BaseEnversEventListener
implements PostDeleteEventListener {
    protected EnversPostDeleteEventListenerImpl(AuditConfiguration enversConfiguration) {
        super(enversConfiguration);
    }

    public void onPostDelete(PostDeleteEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getAuditConfiguration().getEntCfg().isVersioned(entityName)) {
            this.checkIfTransactionInProgress((SessionImplementor)event.getSession());
            AuditProcess auditProcess = this.getAuditConfiguration().getSyncManager().get(event.getSession());
            DelWorkUnit workUnit = new DelWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.getAuditConfiguration(), event.getId(), event.getPersister(), event.getDeletedState());
            auditProcess.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event.getPersister(), entityName, null, event.getDeletedState(), (SessionImplementor)event.getSession());
            }
        }
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return this.getAuditConfiguration().getEntCfg().isVersioned(persister.getEntityName());
    }
}

