/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import java.util.Arrays;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.internal.impl.AbstractAuditQuery;
import org.hibernate.envers.query.internal.impl.AuditAssociationQueryImpl;

public class EntitiesAtRevisionQuery
extends AbstractAuditQuery {
    private final Number revision;
    private final boolean includeDeletions;

    public EntitiesAtRevisionQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, Number revision, boolean includeDeletions) {
        super(enversService, versionsReader, cls);
        this.revision = revision;
        this.includeDeletions = includeDeletions;
    }

    public EntitiesAtRevisionQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, String entityName, Number revision, boolean includeDeletions) {
        super(enversService, versionsReader, cls, entityName);
        this.revision = revision;
        this.includeDeletions = includeDeletions;
    }

    @Override
    public List list() {
        AuditEntitiesConfiguration verEntCfg = this.enversService.getAuditEntitiesConfiguration();
        String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
        String originalIdPropertyName = verEntCfg.getOriginalIdPropName();
        MiddleIdData referencedIdData = new MiddleIdData(verEntCfg, this.enversService.getEntitiesConfigurations().get(this.entityName).getIdMappingData(), null, this.entityName, this.enversService.getEntitiesConfigurations().isVersioned(this.entityName));
        this.enversService.getAuditStrategy().addEntityAtRevisionRestriction(this.enversService.getGlobalConfiguration(), this.qb, this.qb.getRootParameters(), revisionPropertyPath, verEntCfg.getRevisionEndFieldName(), true, referencedIdData, revisionPropertyPath, originalIdPropertyName, "e__", "e2__", true);
        if (!this.includeDeletions) {
            this.qb.getRootParameters().addWhereWithParam(verEntCfg.getRevisionTypePropName(), "<>", (Object)RevisionType.DEL);
        }
        for (AuditCriterion criterion : this.criterions) {
            criterion.addToQuery(this.enversService, this.versionsReader, this.entityName, "e__", this.qb, this.qb.getRootParameters());
        }
        for (AuditAssociationQueryImpl associationQuery : this.associationQueries) {
            associationQuery.addCriterionsToQuery(this.versionsReader);
        }
        Query query = this.buildQuery();
        List<String> params = Arrays.asList(query.getNamedParameters());
        if (params.contains("revision")) {
            query.setParameter("revision", (Object)this.revision);
        }
        List queryResult = query.list();
        return this.applyProjections(queryResult, this.revision);
    }
}

