/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.strategy.AuditStrategy;

public final class ThreeEntityQueryGenerator
extends AbstractRelationQueryGenerator {
    private final String queryString;
    private final String queryRemovedString;

    public ThreeEntityQueryGenerator(GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, AuditStrategy auditStrategy, String versionsMiddleEntityName, MiddleIdData referencingIdData, MiddleIdData referencedIdData, MiddleIdData indexIdData, boolean revisionTypeInId, MiddleComponentData ... componentData) {
        super(verEntCfg, referencingIdData, revisionTypeInId, revisionTypeInId);
        QueryBuilder commonPart = this.commonQueryPart(referencedIdData, indexIdData, versionsMiddleEntityName, verEntCfg.getOriginalIdPropName());
        QueryBuilder validQuery = commonPart.deepCopy();
        QueryBuilder removedQuery = commonPart.deepCopy();
        this.createValidDataRestrictions(globalCfg, auditStrategy, referencedIdData, versionsMiddleEntityName, validQuery, validQuery.getRootParameters(), true, indexIdData, componentData);
        this.createValidAndRemovedDataRestrictions(globalCfg, auditStrategy, referencedIdData, versionsMiddleEntityName, removedQuery, indexIdData, componentData);
        this.queryString = this.queryToString(validQuery);
        this.queryRemovedString = this.queryToString(removedQuery);
    }

    private QueryBuilder commonQueryPart(MiddleIdData referencedIdData, MiddleIdData indexIdData, String versionsMiddleEntityName, String originalIdPropertyName) {
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        QueryBuilder qb = new QueryBuilder(versionsMiddleEntityName, "ee__");
        qb.addFrom(referencedIdData.getAuditEntityName(), "e__", false);
        qb.addFrom(indexIdData.getAuditEntityName(), "f__", false);
        qb.addProjection("new list", "ee__, e__, f__", null, false);
        Parameters rootParameters = qb.getRootParameters();
        referencedIdData.getPrefixedMapper().addIdsEqualToQuery(rootParameters, eeOriginalIdPropertyPath, referencedIdData.getOriginalMapper(), "e__." + originalIdPropertyName);
        indexIdData.getPrefixedMapper().addIdsEqualToQuery(rootParameters, eeOriginalIdPropertyPath, indexIdData.getOriginalMapper(), "f__." + originalIdPropertyName);
        this.referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(rootParameters, originalIdPropertyName, true);
        return qb;
    }

    private void createValidDataRestrictions(GlobalConfiguration globalCfg, AuditStrategy auditStrategy, MiddleIdData referencedIdData, String versionsMiddleEntityName, QueryBuilder qb, Parameters rootParameters, boolean inclusive, MiddleIdData indexIdData, MiddleComponentData ... componentData) {
        String revisionPropertyPath = this.verEntCfg.getRevisionNumberPath();
        String originalIdPropertyName = this.verEntCfg.getOriginalIdPropName();
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        String revisionTypePropName = this.getElementRevisionTypePath();
        auditStrategy.addEntityAtRevisionRestriction(globalCfg, qb, rootParameters, "e__." + revisionPropertyPath, "e__." + this.verEntCfg.getRevisionEndFieldName(), false, referencedIdData, revisionPropertyPath, originalIdPropertyName, "e__", "e2__", true);
        auditStrategy.addEntityAtRevisionRestriction(globalCfg, qb, rootParameters, "f__." + revisionPropertyPath, "f__." + this.verEntCfg.getRevisionEndFieldName(), false, indexIdData, revisionPropertyPath, originalIdPropertyName, "f__", "f2__", true);
        auditStrategy.addAssociationAtRevisionRestriction(qb, rootParameters, revisionPropertyPath, this.verEntCfg.getRevisionEndFieldName(), true, this.referencingIdData, versionsMiddleEntityName, eeOriginalIdPropertyPath, revisionPropertyPath, originalIdPropertyName, "ee__", inclusive, componentData);
        rootParameters.addWhereWithNamedParam(revisionTypePropName, "!=", "delrevisiontype");
        rootParameters.addWhereWithNamedParam("e__." + revisionTypePropName, false, "!=", "delrevisiontype");
        rootParameters.addWhereWithNamedParam("f__." + revisionTypePropName, false, "!=", "delrevisiontype");
    }

    private void createValidAndRemovedDataRestrictions(GlobalConfiguration globalCfg, AuditStrategy auditStrategy, MiddleIdData referencedIdData, String versionsMiddleEntityName, QueryBuilder remQb, MiddleIdData indexIdData, MiddleComponentData ... componentData) {
        Parameters disjoint = remQb.getRootParameters().addSubParameters("or");
        Parameters valid = disjoint.addSubParameters("and");
        Parameters removed = disjoint.addSubParameters("and");
        String revisionPropertyPath = this.verEntCfg.getRevisionNumberPath();
        String revisionTypePropName = this.getElementRevisionTypePath();
        this.createValidDataRestrictions(globalCfg, auditStrategy, referencedIdData, versionsMiddleEntityName, remQb, valid, false, indexIdData, componentData);
        removed.addWhereWithNamedParam(revisionPropertyPath, "=", "revision");
        removed.addWhereWithNamedParam("e__." + revisionPropertyPath, false, "=", "revision");
        removed.addWhereWithNamedParam("f__." + revisionPropertyPath, false, "=", "revision");
        removed.addWhereWithNamedParam(revisionTypePropName, "=", "delrevisiontype");
        removed.addWhereWithNamedParam("e__." + revisionTypePropName, false, "=", "delrevisiontype");
        removed.addWhereWithNamedParam("f__." + revisionTypePropName, false, "=", "delrevisiontype");
    }

    @Override
    protected String getQueryString() {
        return this.queryString;
    }

    @Override
    protected String getQueryRemovedString() {
        return this.queryRemovedString;
    }
}

