/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Properties;
import org.dom4j.Element;
import org.hibernate.envers.configuration.internal.metadata.MetadataTools;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.mapper.SimpleMapperBuilder;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.EnumType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.Type;

public final class BasicMetadataGenerator {
    boolean addBasic(Element parent, PropertyAuditingData propertyAuditingData, Value value, SimpleMapperBuilder mapper, boolean insertable, boolean key) {
        Type type = value.getType();
        if (type instanceof BasicType || type instanceof SerializableToBlobType || "org.hibernate.type.PrimitiveByteArrayBlobType".equals(type.getClass().getName())) {
            if (parent != null) {
                boolean addNestedType = value instanceof SimpleValue && ((SimpleValue)value).getTypeParameters() != null;
                String typeName = type.getName();
                if (typeName == null) {
                    typeName = type.getClass().getName();
                }
                Element propMapping = MetadataTools.addProperty(parent, propertyAuditingData.getName(), addNestedType ? null : typeName, propertyAuditingData.isForceInsertable() || insertable, key);
                MetadataTools.addColumns(propMapping, value.getColumnIterator());
                if (addNestedType) {
                    Properties typeParameters = ((SimpleValue)value).getTypeParameters();
                    Element typeMapping = propMapping.addElement("type");
                    typeMapping.addAttribute("name", typeName);
                    if ("org.hibernate.type.EnumType".equals(typeName)) {
                        this.mapEnumerationType(typeMapping, type, typeParameters);
                    } else {
                        for (Object object : typeParameters.keySet()) {
                            String keyType = (String)object;
                            String property = typeParameters.getProperty(keyType);
                            if (property == null) continue;
                            typeMapping.addElement("param").addAttribute("name", keyType).setText(property);
                        }
                    }
                }
            }
            if (mapper != null) {
                mapper.add(propertyAuditingData.getPropertyData());
            }
        } else {
            return false;
        }
        return true;
    }

    private void mapEnumerationType(Element parent, Type type, Properties parameters) {
        if (parameters.getProperty("enumClass") != null) {
            parent.addElement("param").addAttribute("name", "enumClass").setText(parameters.getProperty("enumClass"));
        } else {
            parent.addElement("param").addAttribute("name", "enumClass").setText(type.getReturnedClass().getName());
        }
        if (parameters.getProperty("useNamed") != null) {
            parent.addElement("param").addAttribute("name", "useNamed").setText(parameters.getProperty("useNamed"));
        } else {
            parent.addElement("param").addAttribute("name", "useNamed").setText("" + !((EnumType)((CustomType)type).getUserType()).isOrdinal());
        }
    }

    boolean addManyToOne(Element parent, PropertyAuditingData propertyAuditingData, Value value, SimpleMapperBuilder mapper) {
        Type type = value.getType();
        Element manyToOneElement = parent.addElement(mapper != null ? "many-to-one" : "key-many-to-one");
        manyToOneElement.addAttribute("name", propertyAuditingData.getName());
        manyToOneElement.addAttribute("class", type.getName());
        if (mapper == null) {
            manyToOneElement.addAttribute("foreign-key", "none");
        }
        MetadataTools.addColumns(manyToOneElement, value.getColumnIterator());
        if (mapper != null) {
            mapper.add(propertyAuditingData.getPropertyData());
        }
        return true;
    }
}

