/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.query;

import java.util.Properties;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.CacheAdapter;
import org.hibernate.cache.infinispan.util.CacheHelper;
import org.hibernate.cache.infinispan.util.FlagAdapter;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.infinispan.notifications.Listener;

@Listener
public class QueryResultsRegionImpl
extends BaseTransactionalDataRegion
implements QueryResultsRegion {
    private boolean localOnly;

    public QueryResultsRegionImpl(CacheAdapter cacheAdapter, String name, Properties properties, TransactionManager transactionManager, RegionFactory factory) {
        super(cacheAdapter, name, null, transactionManager, factory);
        this.localOnly = cacheAdapter.isClusteredInvalidation();
    }

    public void evict(Object key) throws CacheException {
        if (this.localOnly) {
            this.cacheAdapter.withFlags(FlagAdapter.CACHE_MODE_LOCAL).remove(key);
        } else {
            this.cacheAdapter.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() throws CacheException {
        Transaction tx = this.suspend();
        try {
            CacheHelper.sendEvictAllNotification(this.cacheAdapter, this.getAddress());
        }
        finally {
            this.resume(tx);
        }
    }

    public Object get(Object key) throws CacheException {
        boolean skipCacheStore = false;
        if (!this.isValid()) {
            skipCacheStore = true;
        }
        if (!this.checkValid()) {
            return null;
        }
        if (skipCacheStore) {
            return this.get(key, true, FlagAdapter.ZERO_LOCK_ACQUISITION_TIMEOUT, FlagAdapter.SKIP_CACHE_STORE);
        }
        return this.get(key, true, FlagAdapter.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    public void put(Object key, Object value) throws CacheException {
        if (this.checkValid()) {
            if (this.localOnly) {
                this.cacheAdapter.withFlags(FlagAdapter.ZERO_LOCK_ACQUISITION_TIMEOUT, FlagAdapter.CACHE_MODE_LOCAL).putAllowingTimeout(key, value);
            } else {
                this.cacheAdapter.withFlags(FlagAdapter.ZERO_LOCK_ACQUISITION_TIMEOUT).putAllowingTimeout(key, value);
            }
        }
    }
}

