/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional.classloader;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.jboss.logging.Logger;

@Listener
public class CacheAccessListener {
    private static final Logger log = Logger.getLogger(CacheAccessListener.class);
    HashSet modified = new HashSet();
    HashSet accessed = new HashSet();

    public void clear() {
        this.modified.clear();
        this.accessed.clear();
    }

    @CacheEntryModified
    public void nodeModified(CacheEntryModifiedEvent event) {
        if (!event.isPre()) {
            Object key = event.getKey();
            log.info((Object)("Modified node " + key));
            this.modified.add(key.toString());
        }
    }

    @CacheEntryCreated
    public void nodeCreated(CacheEntryCreatedEvent event) {
        if (!event.isPre()) {
            Object key = event.getKey();
            log.info((Object)("Created node " + key));
            this.modified.add(key.toString());
        }
    }

    @CacheEntryVisited
    public void nodeVisited(CacheEntryVisitedEvent event) {
        if (!event.isPre()) {
            Object key = event.getKey();
            log.info((Object)("Visited node " + key));
            this.accessed.add(key.toString());
        }
    }

    public boolean getSawRegionModification(Object key) {
        return this.getSawRegion(key, this.modified);
    }

    public int getSawRegionModificationCount() {
        return this.modified.size();
    }

    public void clearSawRegionModification() {
        this.modified.clear();
    }

    public boolean getSawRegionAccess(Object key) {
        return this.getSawRegion(key, this.accessed);
    }

    public int getSawRegionAccessCount() {
        return this.accessed.size();
    }

    public void clearSawRegionAccess() {
        this.accessed.clear();
    }

    private boolean getSawRegion(Object key, Set sawEvents) {
        if (sawEvents.contains(key)) {
            sawEvents.remove(key);
            return true;
        }
        return false;
    }
}

