/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.entity;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.entity.ReadOnlyAccess;
import org.hibernate.cache.infinispan.entity.TransactionalAccess;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.infinispan.AdvancedCache;

public class EntityRegionImpl
extends BaseTransactionalDataRegion
implements EntityRegion {
    public EntityRegionImpl(AdvancedCache cache, String name, CacheDataDescription metadata, RegionFactory factory) {
        super(cache, name, metadata, factory);
    }

    public EntityRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (AccessType.READ_ONLY.equals((Object)accessType)) {
            return new ReadOnlyAccess(this);
        }
        if (AccessType.TRANSACTIONAL.equals((Object)accessType)) {
            return new TransactionalAccess(this);
        }
        throw new CacheException("Unsupported access type [" + accessType.getExternalName() + "]");
    }

    public PutFromLoadValidator getPutFromLoadValidator() {
        return new PutFromLoadValidator(this.cache);
    }
}

