/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.TypeOverrides;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.infinispan.query.QueryResultsRegionImpl;
import org.hibernate.cache.infinispan.timestamp.TimestampsRegionImpl;
import org.hibernate.cache.infinispan.tm.HibernateTransactionManagerLookup;
import org.hibernate.cfg.Settings;
import org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.testing.ServiceRegistryBuilder;
import org.infinispan.AdvancedCache;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.junit.Assert;
import org.junit.Test;

public class InfinispanRegionFactoryTestCase {
    @Test
    public void testConfigurationProcessing() {
        String person = "com.acme.Person";
        String addresses = "com.acme.Person.addresses";
        Properties p = new Properties();
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.cfg", "person-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.strategy", "LRU");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.wake_up_interval", "2000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.max_entries", "5000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.cfg", "person-addresses-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.lifespan", "120000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.max_idle", "60000");
        p.setProperty("hibernate.cache.infinispan.query.cfg", "my-query-cache");
        p.setProperty("hibernate.cache.infinispan.query.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.query.eviction.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.query.eviction.max_entries", "10000");
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        Assert.assertEquals((Object)"entity", (Object)((TypeOverrides)factory.getTypeOverrides().get("entity")).getCacheName());
        Assert.assertEquals((Object)"entity", (Object)((TypeOverrides)factory.getTypeOverrides().get("collection")).getCacheName());
        Assert.assertEquals((Object)"timestamps", (Object)((TypeOverrides)factory.getTypeOverrides().get("timestamps")).getCacheName());
        Assert.assertEquals((Object)"person-cache", (Object)((TypeOverrides)factory.getTypeOverrides().get("com.acme.Person")).getCacheName());
        Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)((TypeOverrides)factory.getTypeOverrides().get("com.acme.Person")).getEvictionStrategy());
        Assert.assertEquals((long)2000L, (long)((TypeOverrides)factory.getTypeOverrides().get("com.acme.Person")).getEvictionWakeUpInterval());
        Assert.assertEquals((long)5000L, (long)((TypeOverrides)factory.getTypeOverrides().get("com.acme.Person")).getEvictionMaxEntries());
        Assert.assertEquals((long)60000L, (long)((TypeOverrides)factory.getTypeOverrides().get("com.acme.Person")).getExpirationLifespan());
        Assert.assertEquals((long)30000L, (long)((TypeOverrides)factory.getTypeOverrides().get("com.acme.Person")).getExpirationMaxIdle());
        Assert.assertEquals((Object)"person-addresses-cache", (Object)((TypeOverrides)factory.getTypeOverrides().get("com.acme.Person.addresses")).getCacheName());
        Assert.assertEquals((long)120000L, (long)((TypeOverrides)factory.getTypeOverrides().get("com.acme.Person.addresses")).getExpirationLifespan());
        Assert.assertEquals((long)60000L, (long)((TypeOverrides)factory.getTypeOverrides().get("com.acme.Person.addresses")).getExpirationMaxIdle());
        Assert.assertEquals((Object)"my-query-cache", (Object)((TypeOverrides)factory.getTypeOverrides().get("query")).getCacheName());
        Assert.assertEquals((Object)EvictionStrategy.FIFO, (Object)((TypeOverrides)factory.getTypeOverrides().get("query")).getEvictionStrategy());
        Assert.assertEquals((long)3000L, (long)((TypeOverrides)factory.getTypeOverrides().get("query")).getEvictionWakeUpInterval());
        Assert.assertEquals((long)10000L, (long)((TypeOverrides)factory.getTypeOverrides().get("query")).getEvictionMaxEntries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildEntityCollectionRegionsPersonPlusEntityCollectionOverrides() {
        String person = "com.acme.Person";
        String address = "com.acme.Address";
        String car = "com.acme.Car";
        String addresses = "com.acme.Person.addresses";
        String parts = "com.acme.Car.parts";
        Properties p = new Properties();
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.cfg", "person-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.strategy", "LRU");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.wake_up_interval", "2000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.max_entries", "5000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.max_entries", "20000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.cfg", "addresses-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.eviction.wake_up_interval", "2500");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.eviction.max_entries", "5500");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.lifespan", "65000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.max_idle", "35000");
        p.setProperty("hibernate.cache.infinispan.collection.cfg", "mycollection-cache");
        p.setProperty("hibernate.cache.infinispan.collection.eviction.strategy", "LRU");
        p.setProperty("hibernate.cache.infinispan.collection.eviction.wake_up_interval", "3500");
        p.setProperty("hibernate.cache.infinispan.collection.eviction.max_entries", "25000");
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        EmbeddedCacheManager manager = factory.getCacheManager();
        try {
            Assert.assertFalse((boolean)manager.getGlobalConfiguration().isExposeGlobalJmxStatistics());
            Assert.assertNotNull(factory.getTypeOverrides().get("com.acme.Person"));
            Assert.assertFalse((boolean)factory.getDefinedConfigurations().contains("com.acme.Person"));
            Assert.assertNotNull(factory.getTypeOverrides().get("com.acme.Person.addresses"));
            Assert.assertFalse((boolean)factory.getDefinedConfigurations().contains("com.acme.Person.addresses"));
            EntityRegionImpl region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Person", p, null);
            Assert.assertNotNull(factory.getTypeOverrides().get("com.acme.Person"));
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("com.acme.Person"));
            Assert.assertNull(factory.getTypeOverrides().get("com.acme.Address"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((long)2000L, (long)cacheCfg.getEvictionWakeUpInterval());
            Assert.assertEquals((long)5000L, (long)cacheCfg.getEvictionMaxEntries());
            Assert.assertEquals((long)60000L, (long)cacheCfg.getExpirationLifespan());
            Assert.assertEquals((long)30000L, (long)cacheCfg.getExpirationMaxIdle());
            Assert.assertFalse((boolean)cacheCfg.isExposeJmxStatistics());
            region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Address", p, null);
            Assert.assertNotNull(factory.getTypeOverrides().get("com.acme.Person"));
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("com.acme.Person"));
            Assert.assertNull(factory.getTypeOverrides().get("com.acme.Address"));
            cache = region.getCache();
            cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.FIFO, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((long)3000L, (long)cacheCfg.getEvictionWakeUpInterval());
            Assert.assertEquals((long)20000L, (long)cacheCfg.getEvictionMaxEntries());
            Assert.assertFalse((boolean)cacheCfg.isExposeJmxStatistics());
            region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Car", p, null);
            Assert.assertNotNull(factory.getTypeOverrides().get("com.acme.Person"));
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("com.acme.Person"));
            Assert.assertNull(factory.getTypeOverrides().get("com.acme.Address"));
            cache = region.getCache();
            cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.FIFO, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((long)3000L, (long)cacheCfg.getEvictionWakeUpInterval());
            Assert.assertEquals((long)20000L, (long)cacheCfg.getEvictionMaxEntries());
            Assert.assertFalse((boolean)cacheCfg.isExposeJmxStatistics());
            CollectionRegionImpl collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Person.addresses", p, null);
            Assert.assertNotNull(factory.getTypeOverrides().get("com.acme.Person.addresses"));
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("com.acme.Person"));
            Assert.assertNull(factory.getTypeOverrides().get("com.acme.Car.parts"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.FIFO, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((long)2500L, (long)cacheCfg.getEvictionWakeUpInterval());
            Assert.assertEquals((long)5500L, (long)cacheCfg.getEvictionMaxEntries());
            Assert.assertEquals((long)65000L, (long)cacheCfg.getExpirationLifespan());
            Assert.assertEquals((long)35000L, (long)cacheCfg.getExpirationMaxIdle());
            Assert.assertFalse((boolean)cacheCfg.isExposeJmxStatistics());
            collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Car.parts", p, null);
            Assert.assertNotNull(factory.getTypeOverrides().get("com.acme.Person.addresses"));
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("com.acme.Person.addresses"));
            Assert.assertNull(factory.getTypeOverrides().get("com.acme.Car.parts"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((long)3500L, (long)cacheCfg.getEvictionWakeUpInterval());
            Assert.assertEquals((long)25000L, (long)cacheCfg.getEvictionMaxEntries());
            Assert.assertFalse((boolean)cacheCfg.isExposeJmxStatistics());
            collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Car.parts", p, null);
            Assert.assertNotNull(factory.getTypeOverrides().get("com.acme.Person.addresses"));
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("com.acme.Person.addresses"));
            Assert.assertNull(factory.getTypeOverrides().get("com.acme.Car.parts"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((long)3500L, (long)cacheCfg.getEvictionWakeUpInterval());
            Assert.assertEquals((long)25000L, (long)cacheCfg.getEvictionMaxEntries());
            Assert.assertFalse((boolean)cacheCfg.isExposeJmxStatistics());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildEntityCollectionRegionOverridesOnly() {
        Properties p = new Properties();
        p.setProperty("hibernate.cache.infinispan.entity.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.max_entries", "30000");
        p.setProperty("hibernate.cache.infinispan.collection.eviction.strategy", "LRU");
        p.setProperty("hibernate.cache.infinispan.collection.eviction.wake_up_interval", "3500");
        p.setProperty("hibernate.cache.infinispan.collection.eviction.max_entries", "35000");
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        factory.getCacheManager();
        try {
            EntityRegionImpl region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Address", p, null);
            Assert.assertNull(factory.getTypeOverrides().get("com.acme.Address"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.FIFO, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((long)3000L, (long)cacheCfg.getEvictionWakeUpInterval());
            Assert.assertEquals((long)30000L, (long)cacheCfg.getEvictionMaxEntries());
            Assert.assertEquals((long)100000L, (long)cacheCfg.getExpirationMaxIdle());
            CollectionRegionImpl collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Person.addresses", p, null);
            Assert.assertNull(factory.getTypeOverrides().get("com.acme.Person.addresses"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((long)3500L, (long)cacheCfg.getEvictionWakeUpInterval());
            Assert.assertEquals((long)35000L, (long)cacheCfg.getEvictionMaxEntries());
            Assert.assertEquals((long)100000L, (long)cacheCfg.getExpirationMaxIdle());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildEntityRegionPersonPlusEntityOverridesWithoutCfg() {
        String person = "com.acme.Person";
        Properties p = new Properties();
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.strategy", "LRU");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.max_entries", "10000");
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        EmbeddedCacheManager manager = factory.getCacheManager();
        try {
            Assert.assertNotNull(factory.getTypeOverrides().get("com.acme.Person"));
            Assert.assertFalse((boolean)factory.getDefinedConfigurations().contains("com.acme.Person"));
            EntityRegionImpl region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Person", p, null);
            Assert.assertNotNull(factory.getTypeOverrides().get("com.acme.Person"));
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("com.acme.Person"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((long)3000L, (long)cacheCfg.getEvictionWakeUpInterval());
            Assert.assertEquals((long)10000L, (long)cacheCfg.getEvictionMaxEntries());
            Assert.assertEquals((long)60000L, (long)cacheCfg.getExpirationLifespan());
            Assert.assertEquals((long)30000L, (long)cacheCfg.getExpirationMaxIdle());
        }
        finally {
            factory.stop();
        }
    }

    @Test
    public void testTimestampValidation() throws Exception {
        final Properties p = new Properties();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            public void call() {
                InfinispanRegionFactory factory = InfinispanRegionFactoryTestCase.this.createRegionFactory(this.cm, p);
                Configuration config = new Configuration();
                config.setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
                this.cm.defineConfiguration("timestamps", config);
                try {
                    factory.start(null, p);
                    Assert.fail((String)"Should have failed saying that invalidation is not allowed for timestamp caches.");
                }
                catch (CacheException cacheException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildDefaultTimestampsRegion() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        Properties p = new Properties();
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        EmbeddedCacheManager manager = factory.getCacheManager();
        try {
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("timestamps"));
            Assert.assertTrue((boolean)((TypeOverrides)factory.getTypeOverrides().get("timestamps")).getCacheName().equals("timestamps"));
            Configuration config = new Configuration();
            config.setFetchInMemoryState(false);
            manager.defineConfiguration("timestamps", config);
            TimestampsRegionImpl region = (TimestampsRegionImpl)factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.NONE, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((Object)Configuration.CacheMode.REPL_ASYNC, (Object)cacheCfg.getCacheMode());
            Assert.assertTrue((boolean)cacheCfg.isUseLazyDeserialization());
            Assert.assertFalse((boolean)cacheCfg.isExposeJmxStatistics());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildDiffCacheNameTimestampsRegion() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        Properties p = new Properties();
        p.setProperty("hibernate.cache.infinispan.timestamps.cfg", "unrecommended-timestamps");
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        EmbeddedCacheManager manager = factory.getCacheManager();
        try {
            Assert.assertFalse((boolean)factory.getDefinedConfigurations().contains("timestamp"));
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("unrecommended-timestamps"));
            Assert.assertTrue((boolean)((TypeOverrides)factory.getTypeOverrides().get("timestamps")).getCacheName().equals("unrecommended-timestamps"));
            Configuration config = new Configuration();
            config.setFetchInMemoryState(false);
            config.setCacheMode(Configuration.CacheMode.REPL_SYNC);
            manager.defineConfiguration("unrecommended-timestamps", config);
            TimestampsRegionImpl region = (TimestampsRegionImpl)factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.NONE, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((Object)Configuration.CacheMode.REPL_SYNC, (Object)cacheCfg.getCacheMode());
            Assert.assertFalse((boolean)cacheCfg.isUseLazyDeserialization());
            Assert.assertFalse((boolean)cacheCfg.isExposeJmxStatistics());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildTimestamRegionWithCacheNameOverride() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        Properties p = new Properties();
        p.setProperty("hibernate.cache.infinispan.timestamps.cfg", "mytimestamps-cache");
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("mytimestamps-cache"));
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildTimestamRegionWithFifoEvictionOverride() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        Properties p = new Properties();
        p.setProperty("hibernate.cache.infinispan.timestamps.cfg", "mytimestamps-cache");
        p.setProperty("hibernate.cache.infinispan.timestamps.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.timestamps.eviction.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.timestamps.eviction.max_entries", "10000");
        InfinispanRegionFactory factory = null;
        try {
            factory = this.createRegionFactory(p);
            factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("mytimestamps-cache"));
            Assert.fail((String)"Should fail cos no eviction configurations are allowed for timestamp caches");
        }
        catch (CacheException ce) {
        }
        finally {
            if (factory != null) {
                factory.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildTimestamRegionWithNoneEvictionOverride() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        Properties p = new Properties();
        p.setProperty("hibernate.cache.infinispan.timestamps.cfg", "timestamps-none-eviction");
        p.setProperty("hibernate.cache.infinispan.timestamps.eviction.strategy", "NONE");
        p.setProperty("hibernate.cache.infinispan.timestamps.eviction.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.timestamps.eviction.max_entries", "10000");
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        EmbeddedCacheManager manager = factory.getCacheManager();
        manager.getGlobalConfiguration().setTransportClass(null);
        try {
            factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("timestamps-none-eviction"));
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildQueryRegion() {
        String query = "org.hibernate.cache.internal.StandardQueryCache";
        Properties p = new Properties();
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        EmbeddedCacheManager manager = factory.getCacheManager();
        manager.getGlobalConfiguration().setTransportClass(null);
        try {
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("local-query"));
            QueryResultsRegionImpl region = (QueryResultsRegionImpl)factory.buildQueryResultsRegion("org.hibernate.cache.internal.StandardQueryCache", p);
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)Configuration.CacheMode.LOCAL, (Object)cacheCfg.getCacheMode());
            Assert.assertFalse((boolean)cacheCfg.isExposeJmxStatistics());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildQueryRegionWithCustomRegionName() {
        String queryRegionName = "myquery";
        Properties p = new Properties();
        p.setProperty("hibernate.cache.infinispan.myquery.cfg", "timestamps-none-eviction");
        p.setProperty("hibernate.cache.infinispan.myquery.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.myquery.eviction.wake_up_interval", "2222");
        p.setProperty("hibernate.cache.infinispan.myquery.eviction.max_entries", "11111");
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        EmbeddedCacheManager manager = factory.getCacheManager();
        manager.getGlobalConfiguration().setTransportClass(null);
        try {
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("local-query"));
            QueryResultsRegionImpl region = (QueryResultsRegionImpl)factory.buildQueryResultsRegion("myquery", p);
            Assert.assertNotNull(factory.getTypeOverrides().get("myquery"));
            Assert.assertTrue((boolean)factory.getDefinedConfigurations().contains("myquery"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.FIFO, (Object)cacheCfg.getEvictionStrategy());
            Assert.assertEquals((long)2222L, (long)cacheCfg.getEvictionWakeUpInterval());
            Assert.assertEquals((long)11111L, (long)cacheCfg.getEvictionMaxEntries());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableStatistics() {
        Properties p = new Properties();
        p.setProperty("hibernate.cache.infinispan.statistics", "true");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.max_entries", "10000");
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        EmbeddedCacheManager manager = factory.getCacheManager();
        try {
            Assert.assertTrue((boolean)manager.getGlobalConfiguration().isExposeGlobalJmxStatistics());
            EntityRegionImpl region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Address", p, null);
            AdvancedCache cache = region.getCache();
            Assert.assertTrue((boolean)((TypeOverrides)factory.getTypeOverrides().get("entity")).isExposeStatistics());
            Assert.assertTrue((boolean)cache.getConfiguration().isExposeJmxStatistics());
            region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Person", p, null);
            cache = region.getCache();
            Assert.assertTrue((boolean)((TypeOverrides)factory.getTypeOverrides().get("com.acme.Person")).isExposeStatistics());
            Assert.assertTrue((boolean)cache.getConfiguration().isExposeJmxStatistics());
            String query = "org.hibernate.cache.internal.StandardQueryCache";
            QueryResultsRegionImpl queryRegion = (QueryResultsRegionImpl)factory.buildQueryResultsRegion("org.hibernate.cache.internal.StandardQueryCache", p);
            cache = queryRegion.getCache();
            Assert.assertTrue((boolean)((TypeOverrides)factory.getTypeOverrides().get("query")).isExposeStatistics());
            Assert.assertTrue((boolean)cache.getConfiguration().isExposeJmxStatistics());
            String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
            Configuration config = new Configuration();
            config.setFetchInMemoryState(false);
            manager.defineConfiguration("timestamps", config);
            TimestampsRegionImpl timestampsRegion = (TimestampsRegionImpl)factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            cache = timestampsRegion.getCache();
            Assert.assertTrue((boolean)((TypeOverrides)factory.getTypeOverrides().get("timestamps")).isExposeStatistics());
            Assert.assertTrue((boolean)cache.getConfiguration().isExposeJmxStatistics());
            CollectionRegionImpl collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Person.addresses", p, null);
            cache = collectionRegion.getCache();
            Assert.assertTrue((boolean)((TypeOverrides)factory.getTypeOverrides().get("collection")).isExposeStatistics());
            Assert.assertTrue((boolean)cache.getConfiguration().isExposeJmxStatistics());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableStatistics() {
        Properties p = new Properties();
        p.setProperty("hibernate.cache.infinispan.statistics", "false");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.max_entries", "10000");
        InfinispanRegionFactory factory = this.createRegionFactory(p);
        EmbeddedCacheManager manager = factory.getCacheManager();
        try {
            Assert.assertFalse((boolean)manager.getGlobalConfiguration().isExposeGlobalJmxStatistics());
            EntityRegionImpl region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Address", p, null);
            AdvancedCache cache = region.getCache();
            Assert.assertFalse((boolean)((TypeOverrides)factory.getTypeOverrides().get("entity")).isExposeStatistics());
            Assert.assertFalse((boolean)cache.getConfiguration().isExposeJmxStatistics());
            region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Person", p, null);
            cache = region.getCache();
            Assert.assertFalse((boolean)((TypeOverrides)factory.getTypeOverrides().get("com.acme.Person")).isExposeStatistics());
            Assert.assertFalse((boolean)cache.getConfiguration().isExposeJmxStatistics());
            String query = "org.hibernate.cache.internal.StandardQueryCache";
            QueryResultsRegionImpl queryRegion = (QueryResultsRegionImpl)factory.buildQueryResultsRegion("org.hibernate.cache.internal.StandardQueryCache", p);
            cache = queryRegion.getCache();
            Assert.assertFalse((boolean)((TypeOverrides)factory.getTypeOverrides().get("query")).isExposeStatistics());
            Assert.assertFalse((boolean)cache.getConfiguration().isExposeJmxStatistics());
            String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
            Configuration config = new Configuration();
            config.setFetchInMemoryState(false);
            manager.defineConfiguration("timestamps", config);
            TimestampsRegionImpl timestampsRegion = (TimestampsRegionImpl)factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            cache = timestampsRegion.getCache();
            Assert.assertFalse((boolean)((TypeOverrides)factory.getTypeOverrides().get("timestamps")).isExposeStatistics());
            Assert.assertFalse((boolean)cache.getConfiguration().isExposeJmxStatistics());
            CollectionRegionImpl collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Person.addresses", p, null);
            cache = collectionRegion.getCache();
            Assert.assertFalse((boolean)((TypeOverrides)factory.getTypeOverrides().get("collection")).isExposeStatistics());
            Assert.assertFalse((boolean)cache.getConfiguration().isExposeJmxStatistics());
        }
        finally {
            factory.stop();
        }
    }

    private InfinispanRegionFactory createRegionFactory(Properties p) {
        return this.createRegionFactory(null, p);
    }

    private InfinispanRegionFactory createRegionFactory(final EmbeddedCacheManager manager, Properties p) {
        InfinispanRegionFactory factory = new InfinispanRegionFactory(){

            protected TransactionManagerLookup createTransactionManagerLookup(Settings settings, Properties properties) {
                return new HibernateTransactionManagerLookup(null, null){

                    public TransactionManager getTransactionManager() throws Exception {
                        JBossStandAloneJtaPlatform jta = new JBossStandAloneJtaPlatform();
                        jta.injectServices((ServiceRegistryImplementor)ServiceRegistryBuilder.buildServiceRegistry());
                        return jta.getTransactionManager();
                    }
                };
            }

            protected EmbeddedCacheManager createCacheManager(Properties properties) throws CacheException {
                if (manager != null) {
                    return manager;
                }
                return super.createCacheManager(properties);
            }
        };
        factory.start(null, p);
        return factory;
    }
}

