/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.entity;

import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.test.cache.infinispan.entity.AbstractEntityRegionAccessStrategyTestCase;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractReadOnlyAccessTestCase
extends AbstractEntityRegionAccessStrategyTestCase {
    @Override
    protected AccessType getAccessType() {
        return AccessType.READ_ONLY;
    }

    @Override
    @Test
    public void testPutFromLoad() throws Exception {
        this.putFromLoadTest(false);
    }

    @Override
    @Test
    public void testPutFromLoadMinimal() throws Exception {
        this.putFromLoadTest(true);
    }

    private void putFromLoadTest(boolean minimal) throws Exception {
        String KEY = "KEY" + testCount++;
        long txTimestamp = System.currentTimeMillis();
        BatchModeTransactionManager.getInstance().begin();
        Assert.assertNull((Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        if (minimal) {
            this.localAccessStrategy.putFromLoad((Object)KEY, (Object)"VALUE1", txTimestamp, (Object)1, true);
        } else {
            this.localAccessStrategy.putFromLoad((Object)KEY, (Object)"VALUE1", txTimestamp, (Object)1);
        }
        this.sleep(250L);
        String expected = this.isUsingInvalidation() ? null : "VALUE1";
        Assert.assertEquals((Object)expected, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        BatchModeTransactionManager.getInstance().commit();
        Assert.assertEquals((Object)"VALUE1", (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals((Object)expected, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testUpdate() throws Exception {
        this.localAccessStrategy.update((Object)("KEY" + testCount++), (Object)"VALUE2", (Object)2, (Object)1);
    }
}

