/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan;

import java.util.Map;
import java.util.Set;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.AbstractRegionImplTestCase;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.infinispan.AdvancedCache;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractGeneralDataRegionTestCase
extends AbstractRegionImplTestCase {
    private static final Logger log = Logger.getLogger(AbstractGeneralDataRegionTestCase.class);
    protected static final String KEY = "Key";
    protected static final String VALUE1 = "value1";
    protected static final String VALUE2 = "value2";

    protected Configuration createConfiguration() {
        return CacheTestUtil.buildConfiguration("test", InfinispanRegionFactory.class, false, true);
    }

    @Override
    protected void putInRegion(Region region, Object key, Object value) {
        ((GeneralDataRegion)region).put(key, value);
    }

    @Override
    protected void removeFromRegion(Region region, Object key) {
        ((GeneralDataRegion)region).evict(key);
    }

    @Test
    public void testEvict() throws Exception {
        this.evictOrRemoveTest();
    }

    private void evictOrRemoveTest() throws Exception {
        Configuration cfg = this.createConfiguration();
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).build(), cfg, this.getCacheTestSupport());
        boolean invalidation = false;
        this.avoidConcurrentFlush();
        GeneralDataRegion localRegion = (GeneralDataRegion)this.createRegion(regionFactory, this.getStandardRegionName("test"), cfg.getProperties(), null);
        cfg = this.createConfiguration();
        regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).build(), cfg, this.getCacheTestSupport());
        GeneralDataRegion remoteRegion = (GeneralDataRegion)this.createRegion(regionFactory, this.getStandardRegionName("test"), cfg.getProperties(), null);
        Assert.assertNull((String)"local is clean", (Object)localRegion.get((Object)KEY));
        Assert.assertNull((String)"remote is clean", (Object)remoteRegion.get((Object)KEY));
        this.regionPut(localRegion);
        Assert.assertEquals((Object)VALUE1, (Object)localRegion.get((Object)KEY));
        this.sleep(250L);
        String expected = invalidation ? null : VALUE1;
        Assert.assertEquals((Object)expected, (Object)remoteRegion.get((Object)KEY));
        this.regionEvict(localRegion);
        this.sleep(250L);
        Assert.assertEquals(null, (Object)localRegion.get((Object)KEY));
        Assert.assertEquals(null, (Object)remoteRegion.get((Object)KEY));
    }

    protected void regionEvict(GeneralDataRegion region) throws Exception {
        region.evict((Object)KEY);
    }

    protected void regionPut(GeneralDataRegion region) throws Exception {
        region.put((Object)KEY, (Object)VALUE1);
    }

    protected abstract String getStandardRegionName(String var1);

    public void testEvictAll() throws Exception {
        this.evictOrRemoveAllTest("entity");
    }

    private void evictOrRemoveAllTest(String configName) throws Exception {
        Configuration cfg = this.createConfiguration();
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).build(), cfg, this.getCacheTestSupport());
        AdvancedCache localCache = this.getInfinispanCache(regionFactory);
        this.avoidConcurrentFlush();
        GeneralDataRegion localRegion = (GeneralDataRegion)this.createRegion(regionFactory, this.getStandardRegionName("test"), cfg.getProperties(), null);
        cfg = this.createConfiguration();
        regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).build(), cfg, this.getCacheTestSupport());
        AdvancedCache remoteCache = this.getInfinispanCache(regionFactory);
        this.avoidConcurrentFlush();
        GeneralDataRegion remoteRegion = (GeneralDataRegion)this.createRegion(regionFactory, this.getStandardRegionName("test"), cfg.getProperties(), null);
        Set keys = localCache.keySet();
        Assert.assertEquals((String)("No valid children in " + keys), (long)0L, (long)this.getValidKeyCount(keys));
        keys = remoteCache.keySet();
        Assert.assertEquals((String)("No valid children in " + keys), (long)0L, (long)this.getValidKeyCount(keys));
        Assert.assertNull((String)"local is clean", (Object)localRegion.get((Object)KEY));
        Assert.assertNull((String)"remote is clean", (Object)remoteRegion.get((Object)KEY));
        this.regionPut(localRegion);
        Assert.assertEquals((Object)VALUE1, (Object)localRegion.get((Object)KEY));
        this.sleep(250L);
        this.regionPut(remoteRegion);
        Assert.assertEquals((Object)VALUE1, (Object)remoteRegion.get((Object)KEY));
        this.sleep(250L);
        localRegion.evictAll();
        this.sleep(250L);
        Assert.assertNull((Object)localRegion.get((Object)KEY));
        Assert.assertEquals((String)("No valid children in " + keys), (long)0L, (long)this.getValidKeyCount(localCache.keySet()));
        Assert.assertEquals(null, (Object)remoteRegion.get((Object)KEY));
        Assert.assertEquals((String)("No valid children in " + keys), (long)0L, (long)this.getValidKeyCount(remoteCache.keySet()));
        Assert.assertEquals((String)"local is clean", null, (Object)localRegion.get((Object)KEY));
        Assert.assertEquals((String)"remote is clean", null, (Object)remoteRegion.get((Object)KEY));
    }

    protected void rollback() {
        try {
            BatchModeTransactionManager.getInstance().rollback();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

