/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;

public class NodeEnvironment {
    private final Configuration configuration;
    private StandardServiceRegistryImpl serviceRegistry;
    private InfinispanRegionFactory regionFactory;
    private Map<String, EntityRegionImpl> entityRegionMap;
    private Map<String, CollectionRegionImpl> collectionRegionMap;

    public NodeEnvironment(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public StandardServiceRegistryImpl getServiceRegistry() {
        return this.serviceRegistry;
    }

    public EntityRegionImpl getEntityRegion(String name, CacheDataDescription cacheDataDescription) {
        if (this.entityRegionMap == null) {
            this.entityRegionMap = new HashMap<String, EntityRegionImpl>();
            return this.buildAndStoreEntityRegion(name, cacheDataDescription);
        }
        EntityRegionImpl region = this.entityRegionMap.get(name);
        if (region == null) {
            region = this.buildAndStoreEntityRegion(name, cacheDataDescription);
        }
        return region;
    }

    private EntityRegionImpl buildAndStoreEntityRegion(String name, CacheDataDescription cacheDataDescription) {
        EntityRegionImpl region = (EntityRegionImpl)this.regionFactory.buildEntityRegion(name, this.configuration.getProperties(), cacheDataDescription);
        this.entityRegionMap.put(name, region);
        return region;
    }

    public CollectionRegionImpl getCollectionRegion(String name, CacheDataDescription cacheDataDescription) {
        if (this.collectionRegionMap == null) {
            this.collectionRegionMap = new HashMap<String, CollectionRegionImpl>();
            return this.buildAndStoreCollectionRegion(name, cacheDataDescription);
        }
        CollectionRegionImpl region = this.collectionRegionMap.get(name);
        if (region == null) {
            region = this.buildAndStoreCollectionRegion(name, cacheDataDescription);
            this.collectionRegionMap.put(name, region);
        }
        return region;
    }

    private CollectionRegionImpl buildAndStoreCollectionRegion(String name, CacheDataDescription cacheDataDescription) {
        CollectionRegionImpl region = (CollectionRegionImpl)this.regionFactory.buildCollectionRegion(name, this.configuration.getProperties(), cacheDataDescription);
        return region;
    }

    public void prepare() throws Exception {
        this.serviceRegistry = (StandardServiceRegistryImpl)new StandardServiceRegistryBuilder().applySettings((Map)this.configuration.getProperties()).build();
        this.regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)this.serviceRegistry, this.configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws Exception {
        try {
            if (this.entityRegionMap != null) {
                for (EntityRegionImpl region : this.entityRegionMap.values()) {
                    try {
                        region.getCache().stop();
                    }
                    catch (Exception e) {}
                }
                this.entityRegionMap.clear();
            }
            if (this.collectionRegionMap != null) {
                for (CollectionRegionImpl reg : this.collectionRegionMap.values()) {
                    try {
                        reg.getCache().stop();
                    }
                    catch (Exception exception) {}
                }
                this.collectionRegionMap.clear();
            }
        }
        finally {
            try {
                if (this.regionFactory != null) {
                    this.regionFactory.stop();
                }
            }
            finally {
                if (this.serviceRegistry != null) {
                    this.serviceRegistry.destroy();
                }
            }
        }
    }
}

