/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import javax.transaction.TransactionManager;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.transaction.internal.jta.CMTTransactionFactory;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.test.cache.infinispan.tm.JtaPlatformImpl;
import org.hibernate.test.cache.infinispan.tm.XaConnectionProvider;
import org.hibernate.testing.junit4.BaseCoreFunctionalTestCase;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Before;

public abstract class SingleNodeTestCase
extends BaseCoreFunctionalTestCase {
    private static final Log log = LogFactory.getLog(SingleNodeTestCase.class);
    protected TransactionManager tm;

    @Before
    public void prepare() {
        this.tm = this.getTransactionManager();
    }

    protected TransactionManager getTransactionManager() {
        try {
            Class<? extends JtaPlatform> jtaPlatformClass = this.getJtaPlatform();
            if (jtaPlatformClass == null) {
                return null;
            }
            return jtaPlatformClass.newInstance().retrieveTransactionManager();
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String[] getMappings() {
        return new String[]{"cache/infinispan/functional/Item.hbm.xml", "cache/infinispan/functional/Customer.hbm.xml", "cache/infinispan/functional/Contact.hbm.xml"};
    }

    public String getCacheConcurrencyStrategy() {
        return "transactional";
    }

    protected Class<? extends RegionFactory> getCacheRegionFactory() {
        return TestInfinispanRegionFactory.class;
    }

    protected Class<? extends TransactionFactory> getTransactionFactoryClass() {
        return CMTTransactionFactory.class;
    }

    protected Class<? extends ConnectionProvider> getConnectionProviderClass() {
        return XaConnectionProvider.class;
    }

    protected Class<? extends JtaPlatform> getJtaPlatform() {
        return JtaPlatformImpl.class;
    }

    protected boolean getUseQueryCache() {
        return true;
    }

    public void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.cache.use_second_level_cache", "true");
        cfg.setProperty("hibernate.generate_statistics", "true");
        cfg.setProperty("hibernate.cache.use_query_cache", String.valueOf(this.getUseQueryCache()));
        cfg.setProperty("hibernate.cache.region.factory_class", this.getCacheRegionFactory().getName());
        if (this.getJtaPlatform() != null) {
            cfg.getProperties().put("hibernate.transaction.jta.platform", this.getJtaPlatform());
        }
        cfg.setProperty("hibernate.transaction.factory_class", this.getTransactionFactoryClass().getName());
        cfg.setProperty("hibernate.connection.provider_class", this.getConnectionProviderClass().getName());
    }

    protected void beginTx() throws Exception {
        this.tm.begin();
    }

    protected void setRollbackOnlyTx() throws Exception {
        this.tm.setRollbackOnly();
    }

    protected void setRollbackOnlyTx(Exception e) throws Exception {
        log.error((Object)"Error", (Throwable)e);
        this.tm.setRollbackOnly();
        throw e;
    }

    protected void setRollbackOnlyTxExpected(Exception e) throws Exception {
        log.debug((Object)"Expected behaivour", (Throwable)e);
        this.tm.setRollbackOnly();
    }

    protected void commitOrRollbackTx() throws Exception {
        if (this.tm.getStatus() == 0) {
            this.tm.commit();
        } else {
            this.tm.rollback();
        }
    }

    public static class TestInfinispanRegionFactory
    extends InfinispanRegionFactory {
        protected EmbeddedCacheManager createCacheManager(ConfigurationBuilderHolder holder) {
            return TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilderHolder)holder);
        }
    }
}

