/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional.bulk;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import javax.transaction.TransactionManager;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.transaction.internal.jta.CMTTransactionFactory;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.test.cache.infinispan.functional.Contact;
import org.hibernate.test.cache.infinispan.functional.Customer;
import org.hibernate.test.cache.infinispan.functional.SingleNodeTestCase;
import org.hibernate.test.cache.infinispan.tm.JtaPlatformImpl;
import org.hibernate.test.cache.infinispan.tm.XaConnectionProvider;
import org.hibernate.testing.junit4.BaseCoreFunctionalTestCase;
import org.junit.Assert;
import org.junit.Test;

public class BulkOperationsTestCase
extends BaseCoreFunctionalTestCase {
    private TransactionManager tm;

    public String[] getMappings() {
        return new String[]{"cache/infinispan/functional/Contact.hbm.xml", "cache/infinispan/functional/Customer.hbm.xml"};
    }

    public String getCacheConcurrencyStrategy() {
        return "transactional";
    }

    protected Class<? extends RegionFactory> getCacheRegionFactory() {
        return SingleNodeTestCase.TestInfinispanRegionFactory.class;
    }

    protected Class<? extends TransactionFactory> getTransactionFactoryClass() {
        return CMTTransactionFactory.class;
    }

    protected Class<? extends ConnectionProvider> getConnectionProviderClass() {
        return XaConnectionProvider.class;
    }

    protected JtaPlatform getJtaPlatform() {
        return new JtaPlatformImpl();
    }

    public void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.cache.use_second_level_cache", "true");
        cfg.setProperty("hibernate.generate_statistics", "true");
        cfg.setProperty("hibernate.cache.use_query_cache", "false");
        cfg.setProperty("hibernate.cache.region.factory_class", this.getCacheRegionFactory().getName());
        cfg.setProperty("hibernate.transaction.factory_class", this.getTransactionFactoryClass().getName());
        cfg.getProperties().put("hibernate.transaction.jta.platform", this.getJtaPlatform());
        cfg.setProperty("hibernate.connection.provider_class", this.getConnectionProviderClass().getName());
    }

    @Test
    public void testBulkOperations() throws Throwable {
        boolean cleanedUp = false;
        try {
            this.tm = this.getJtaPlatform().retrieveTransactionManager();
            this.createContacts();
            List<Integer> rhContacts = this.getContactsByCustomer("Red Hat");
            Assert.assertNotNull((String)"Red Hat contacts exist", rhContacts);
            Assert.assertEquals((String)"Created expected number of Red Hat contacts", (long)10L, (long)rhContacts.size());
            SecondLevelCacheStatistics contactSlcs = this.sessionFactory().getStatistics().getSecondLevelCacheStatistics(Contact.class.getName());
            Assert.assertEquals((long)20L, (long)contactSlcs.getElementCountInMemory());
            Assert.assertEquals((String)"Deleted all Red Hat contacts", (long)10L, (long)this.deleteContacts());
            Assert.assertEquals((long)0L, (long)contactSlcs.getElementCountInMemory());
            List<Integer> jbContacts = this.getContactsByCustomer("JBoss");
            Assert.assertNotNull((String)"JBoss contacts exist", jbContacts);
            Assert.assertEquals((String)"JBoss contacts remain", (long)10L, (long)jbContacts.size());
            for (Integer id : rhContacts) {
                Assert.assertNull((String)("Red Hat contact " + id + " cannot be retrieved"), (Object)this.getContact(id));
            }
            rhContacts = this.getContactsByCustomer("Red Hat");
            if (rhContacts != null) {
                Assert.assertEquals((String)"No Red Hat contacts remain", (long)0L, (long)rhContacts.size());
            }
            this.updateContacts("Kabir", "Updated");
            Assert.assertEquals((long)0L, (long)contactSlcs.getElementCountInMemory());
            for (Integer id : jbContacts) {
                Contact contact = this.getContact(id);
                Assert.assertNotNull((String)("JBoss contact " + id + " exists"), (Object)contact);
                String expected = "Kabir".equals(contact.getName()) ? "Updated" : "2222";
                Assert.assertEquals((String)("JBoss contact " + id + " has correct TLF"), (Object)expected, (Object)contact.getTlf());
            }
            List<Integer> updated = this.getContactsByTLF("Updated");
            Assert.assertNotNull((String)"Got updated contacts", updated);
            Assert.assertEquals((String)"Updated contacts", (long)5L, (long)updated.size());
            this.updateContactsWithOneManual("Kabir", "UpdatedAgain");
            Assert.assertEquals((long)contactSlcs.getElementCountInMemory(), (long)0L);
            for (Integer id : jbContacts) {
                Contact contact = this.getContact(id);
                Assert.assertNotNull((String)("JBoss contact " + id + " exists"), (Object)contact);
                String expected = "Kabir".equals(contact.getName()) ? "UpdatedAgain" : "2222";
                Assert.assertEquals((String)("JBoss contact " + id + " has correct TLF"), (Object)expected, (Object)contact.getTlf());
            }
            updated = this.getContactsByTLF("UpdatedAgain");
            Assert.assertNotNull((String)"Got updated contacts", updated);
            Assert.assertEquals((String)"Updated contacts", (long)5L, (long)updated.size());
        }
        catch (Throwable t) {
            cleanedUp = true;
            this.cleanup(true);
            throw t;
        }
        finally {
            if (!cleanedUp) {
                this.cleanup(false);
            }
        }
    }

    public void createContacts() throws Exception {
        this.tm.begin();
        try {
            for (int i = 0; i < 10; ++i) {
                this.createCustomer(i);
            }
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
    }

    public int deleteContacts() throws Exception {
        String deleteHQL = "delete Contact where customer in ";
        deleteHQL = deleteHQL + " (select customer FROM Customer as customer ";
        deleteHQL = deleteHQL + " where customer.name = :cName)";
        this.tm.begin();
        try {
            Session session = this.sessionFactory().getCurrentSession();
            int rowsAffected = session.createQuery(deleteHQL).setFlushMode(FlushMode.AUTO).setParameter("cName", (Object)"Red Hat").executeUpdate();
            this.tm.commit();
            int n = rowsAffected;
            return n;
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.tm.commit();
            } else {
                try {
                    this.tm.rollback();
                }
                catch (Exception ee) {}
            }
        }
    }

    public List<Integer> getContactsByCustomer(String customerName) throws Exception {
        String selectHQL = "select contact.id from Contact contact";
        selectHQL = selectHQL + " where contact.customer.name = :cName";
        this.tm.begin();
        try {
            Session session = this.sessionFactory().getCurrentSession();
            List list = session.createQuery(selectHQL).setFlushMode(FlushMode.AUTO).setParameter("cName", (Object)customerName).list();
            return list;
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
    }

    public List<Integer> getContactsByTLF(String tlf) throws Exception {
        String selectHQL = "select contact.id from Contact contact";
        selectHQL = selectHQL + " where contact.tlf = :cTLF";
        this.tm.begin();
        try {
            Session session = this.sessionFactory().getCurrentSession();
            List list = session.createQuery(selectHQL).setFlushMode(FlushMode.AUTO).setParameter("cTLF", (Object)tlf).list();
            return list;
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
    }

    public int updateContacts(String name, String newTLF) throws Exception {
        String updateHQL = "update Contact set tlf = :cNewTLF where name = :cName";
        this.tm.begin();
        try {
            Session session = this.sessionFactory().getCurrentSession();
            int n = session.createQuery(updateHQL).setFlushMode(FlushMode.AUTO).setParameter("cNewTLF", (Object)newTLF).setParameter("cName", (Object)name).executeUpdate();
            return n;
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
    }

    public int updateContactsWithOneManual(String name, String newTLF) throws Exception {
        String queryHQL = "from Contact c where c.name = :cName";
        String updateHQL = "update Contact set tlf = :cNewTLF where name = :cName";
        this.tm.begin();
        try {
            Session session = this.sessionFactory().getCurrentSession();
            List list = session.createQuery(queryHQL).setParameter("cName", (Object)name).list();
            ((Contact)list.get(0)).setTlf(newTLF);
            int n = session.createQuery(updateHQL).setFlushMode(FlushMode.AUTO).setParameter("cNewTLF", (Object)newTLF).setParameter("cName", (Object)name).executeUpdate();
            return n;
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
    }

    public Contact getContact(Integer id) throws Exception {
        this.tm.begin();
        try {
            Session session = this.sessionFactory().getCurrentSession();
            Contact contact = (Contact)session.get(Contact.class, (Serializable)id);
            return contact;
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
    }

    public void cleanup(boolean ignore) throws Exception {
        String deleteContactHQL = "delete from Contact";
        String deleteCustomerHQL = "delete from Customer";
        this.tm.begin();
        try {
            Session session = this.sessionFactory().getCurrentSession();
            session.createQuery(deleteContactHQL).setFlushMode(FlushMode.AUTO).executeUpdate();
            session.createQuery(deleteCustomerHQL).setFlushMode(FlushMode.AUTO).executeUpdate();
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.tm.commit();
            } else if (!ignore) {
                try {
                    this.tm.rollback();
                }
                catch (Exception ee) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Customer createCustomer(int id) throws Exception {
        System.out.println("CREATE CUSTOMER " + id);
        try {
            Customer customer = new Customer();
            customer.setName(id % 2 == 0 ? "JBoss" : "Red Hat");
            HashSet<Contact> contacts = new HashSet<Contact>();
            Contact kabir = new Contact();
            kabir.setCustomer(customer);
            kabir.setName("Kabir");
            kabir.setTlf("1111");
            contacts.add(kabir);
            Contact bill = new Contact();
            bill.setCustomer(customer);
            bill.setName("Bill");
            bill.setTlf("2222");
            contacts.add(bill);
            customer.setContacts(contacts);
            Session s = this.openSession();
            s.getTransaction().begin();
            s.persist((Object)customer);
            s.getTransaction().commit();
            s.close();
            Customer customer2 = customer;
            return customer2;
        }
        finally {
            System.out.println("CREATE CUSTOMER " + id + " -  END");
        }
    }
}

