/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.query;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import junit.framework.AssertionFailedError;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.internal.StandardQueryCache;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.AbstractGeneralDataRegionTestCase;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.infinispan.AdvancedCache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.logging.Logger;
import org.junit.Assert;

public class QueryRegionImplTestCase
extends AbstractGeneralDataRegionTestCase {
    private static final Logger log = Logger.getLogger(QueryRegionImplTestCase.class);

    @Override
    protected Region createRegion(InfinispanRegionFactory regionFactory, String regionName, Properties properties, CacheDataDescription cdd) {
        return regionFactory.buildQueryResultsRegion(regionName, properties);
    }

    @Override
    protected String getStandardRegionName(String regionPrefix) {
        return regionPrefix + "/" + StandardQueryCache.class.getName();
    }

    @Override
    protected void regionPut(final GeneralDataRegion region) throws Exception {
        Caches.withinTx((TransactionManager)BatchModeTransactionManager.getInstance(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                region.put((Object)"Key", (Object)"value1");
                return null;
            }
        });
    }

    @Override
    protected void regionEvict(final GeneralDataRegion region) throws Exception {
        Caches.withinTx((TransactionManager)BatchModeTransactionManager.getInstance(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                region.evict((Object)"Key");
                return null;
            }
        });
    }

    @Override
    protected AdvancedCache getInfinispanCache(InfinispanRegionFactory regionFactory) {
        return regionFactory.getCacheManager().getCache("local-query").getAdvancedCache();
    }

    @Override
    protected Configuration createConfiguration() {
        return CacheTestUtil.buildCustomQueryCacheConfiguration("test", "replicated-query");
    }

    private void putDoesNotBlockGetTest() throws Exception {
        Configuration cfg = this.createConfiguration();
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).build(), cfg, this.getCacheTestSupport());
        this.avoidConcurrentFlush();
        final QueryResultsRegion region = regionFactory.buildQueryResultsRegion(this.getStandardRegionName("test"), cfg.getProperties());
        region.put((Object)"Key", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)region.get((Object)"Key"));
        final CountDownLatch readerLatch = new CountDownLatch(1);
        final CountDownLatch writerLatch = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(1);
        final ExceptionHolder holder = new ExceptionHolder();
        Thread reader = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BatchModeTransactionManager.getInstance().begin();
                    log.debug((Object)"Transaction began, get value for key");
                    Assert.assertTrue((!"value2".equals(region.get((Object)"Key")) ? 1 : 0) != 0);
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (AssertionFailedError e) {
                    holder.a1 = e;
                    QueryRegionImplTestCase.this.rollback();
                }
                catch (Exception e) {
                    holder.e1 = e;
                    QueryRegionImplTestCase.this.rollback();
                }
                finally {
                    readerLatch.countDown();
                }
            }
        };
        Thread writer = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BatchModeTransactionManager.getInstance().begin();
                    log.debug((Object)"Put value2");
                    region.put((Object)"Key", (Object)"value2");
                    log.debug((Object)"Put finished for value2, await writer latch");
                    writerLatch.await();
                    log.debug((Object)"Writer latch finished");
                    BatchModeTransactionManager.getInstance().commit();
                    log.debug((Object)"Transaction committed");
                }
                catch (Exception e) {
                    holder.e2 = e;
                    QueryRegionImplTestCase.this.rollback();
                }
                finally {
                    completionLatch.countDown();
                }
            }
        };
        reader.setDaemon(true);
        writer.setDaemon(true);
        writer.start();
        Assert.assertFalse((String)"Writer is blocking", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
        reader.start();
        Assert.assertTrue((String)"Reader finished promptly", (boolean)readerLatch.await(1000000000L, TimeUnit.MILLISECONDS));
        writerLatch.countDown();
        Assert.assertTrue((String)"Reader finished promptly", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)"value2", (Object)region.get((Object)"Key"));
        if (holder.a1 != null) {
            throw holder.a1;
        }
        if (holder.a2 != null) {
            throw holder.a2;
        }
        Assert.assertEquals((String)"writer saw no exceptions", null, (Object)holder.e1);
        Assert.assertEquals((String)"reader saw no exceptions", null, (Object)holder.e2);
    }

    public void testGetDoesNotBlockPut() throws Exception {
        this.getDoesNotBlockPutTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDoesNotBlockPutTest() throws Exception {
        Configuration cfg = this.createConfiguration();
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).build(), cfg, this.getCacheTestSupport());
        this.avoidConcurrentFlush();
        final QueryResultsRegion region = regionFactory.buildQueryResultsRegion(this.getStandardRegionName("test"), cfg.getProperties());
        region.put((Object)"Key", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)region.get((Object)"Key"));
        final AdvancedCache jbc = this.getInfinispanCache(regionFactory);
        final CountDownLatch blockerLatch = new CountDownLatch(1);
        final CountDownLatch writerLatch = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(1);
        final ExceptionHolder holder = new ExceptionHolder();
        Thread blocker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GetBlocker blocker = new GetBlocker(blockerLatch, "Key");
                try {
                    jbc.addListener((Object)blocker);
                    BatchModeTransactionManager.getInstance().begin();
                    region.get((Object)"Key");
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    holder.e1 = e;
                    QueryRegionImplTestCase.this.rollback();
                }
                finally {
                    jbc.removeListener((Object)blocker);
                }
            }
        };
        Thread writer = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    writerLatch.await();
                    BatchModeTransactionManager.getInstance().begin();
                    region.put((Object)"Key", (Object)"value2");
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    holder.e2 = e;
                    QueryRegionImplTestCase.this.rollback();
                }
                finally {
                    completionLatch.countDown();
                }
            }
        };
        blocker.setDaemon(true);
        writer.setDaemon(true);
        boolean unblocked = false;
        try {
            blocker.start();
            writer.start();
            Assert.assertFalse((String)"Blocker is blocking", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
            writerLatch.countDown();
            Assert.assertTrue((String)"Writer finished promptly", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
            blockerLatch.countDown();
            unblocked = true;
            if (IsolationLevel.REPEATABLE_READ.equals((Object)jbc.getConfiguration().getIsolationLevel())) {
                Assert.assertEquals((Object)"value1", (Object)region.get((Object)"Key"));
            } else {
                Assert.assertEquals((Object)"value2", (Object)region.get((Object)"Key"));
            }
            if (holder.a1 != null) {
                throw holder.a1;
            }
            if (holder.a2 != null) {
                throw holder.a2;
            }
            Assert.assertEquals((String)"blocker saw no exceptions", null, (Object)holder.e1);
            Assert.assertEquals((String)"writer saw no exceptions", null, (Object)holder.e2);
        }
        finally {
            if (!unblocked) {
                blockerLatch.countDown();
            }
        }
    }

    private class ExceptionHolder {
        Exception e1;
        Exception e2;
        AssertionFailedError a1;
        AssertionFailedError a2;

        private ExceptionHolder() {
        }
    }

    @Listener
    public class GetBlocker {
        private CountDownLatch latch;
        private Object key;

        GetBlocker(CountDownLatch latch, Object key) {
            this.latch = latch;
            this.key = key;
        }

        @CacheEntryVisited
        public void nodeVisisted(CacheEntryVisitedEvent event) {
            if (event.isPre() && event.getKey().equals(this.key)) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    log.error((Object)"Interrupted waiting for latch", (Throwable)e);
                }
            }
        }
    }
}

