/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.timestamp;

import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.timestamp.TimestampsRegionImpl;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.AbstractGeneralDataRegionTestCase;
import org.hibernate.test.cache.infinispan.functional.SingleNodeTestCase;
import org.hibernate.test.cache.infinispan.functional.classloader.Account;
import org.hibernate.test.cache.infinispan.functional.classloader.AccountHolder;
import org.hibernate.test.cache.infinispan.functional.classloader.SelectedClassnameClassLoader;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.hibernate.test.cache.infinispan.util.ClassLoaderAwareCache;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.Event;

public class TimestampsRegionImplTestCase
extends AbstractGeneralDataRegionTestCase {
    @Override
    protected String getStandardRegionName(String regionPrefix) {
        return regionPrefix + "/" + UpdateTimestampsCache.class.getName();
    }

    @Override
    protected Region createRegion(InfinispanRegionFactory regionFactory, String regionName, Properties properties, CacheDataDescription cdd) {
        return regionFactory.buildTimestampsRegion(regionName, properties);
    }

    @Override
    protected AdvancedCache getInfinispanCache(InfinispanRegionFactory regionFactory) {
        return regionFactory.getCacheManager().getCache("timestamps").getAdvancedCache();
    }

    public void testClearTimestampsRegionInIsolated() throws Exception {
        Configuration cfg = this.createConfiguration();
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).build(), cfg, this.getCacheTestSupport());
        this.avoidConcurrentFlush();
        Configuration cfg2 = this.createConfiguration();
        InfinispanRegionFactory regionFactory2 = CacheTestUtil.startRegionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).build(), cfg2, this.getCacheTestSupport());
        this.avoidConcurrentFlush();
        TimestampsRegionImpl region = (TimestampsRegionImpl)regionFactory.buildTimestampsRegion(this.getStandardRegionName("test"), cfg.getProperties());
        TimestampsRegionImpl region2 = (TimestampsRegionImpl)regionFactory2.buildTimestampsRegion(this.getStandardRegionName("test"), cfg2.getProperties());
        Account acct = new Account();
        acct.setAccountHolder(new AccountHolder());
        region.getCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).put((Object)acct, (Object)"boo");
    }

    @Override
    protected Configuration createConfiguration() {
        return CacheTestUtil.buildConfiguration("test", MockInfinispanRegionFactory.class, false, true);
    }

    public static class MockInfinispanRegionFactory
    extends SingleNodeTestCase.TestInfinispanRegionFactory {
        protected AdvancedCache createCacheWrapper(AdvancedCache cache) {
            return new ClassLoaderAwareCache(cache, Thread.currentThread().getContextClassLoader()){

                @Override
                public void addListener(Object listener) {
                    super.addListener(new MockClassLoaderAwareListener(listener, this));
                }
            };
        }

        @Listener
        public static class MockClassLoaderAwareListener
        extends ClassLoaderAwareCache.ClassLoaderAwareListener {
            MockClassLoaderAwareListener(Object listener, ClassLoaderAwareCache cache) {
                super(listener, cache);
            }

            @Override
            @CacheEntryActivated
            @CacheEntryCreated
            @CacheEntryEvicted
            @CacheEntryInvalidated
            @CacheEntryLoaded
            @CacheEntryModified
            @CacheEntryPassivated
            @CacheEntryRemoved
            @CacheEntryVisited
            public void event(Event event) throws Throwable {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                String notFoundPackage = "org.hibernate.test.cache.infinispan.functional.classloader";
                String[] notFoundClasses = new String[]{notFoundPackage + ".Account", notFoundPackage + ".AccountHolder"};
                SelectedClassnameClassLoader visible = new SelectedClassnameClassLoader(null, null, notFoundClasses, cl);
                Thread.currentThread().setContextClassLoader(visible);
                super.event(event);
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }
}

